% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curvefunctions.R
\name{fwd2spot}
\alias{fwd2spot}
\title{Forward curve conversion}
\usage{
fwd2spot(dates, fwd, approximation = "constant")
}
\arguments{
\item{dates}{Term structure of rates.}

\item{fwd}{Numeric vector of forward rates to be converted.}

\item{approximation}{String that establish the approximation. Set
\code{'linear'} for a piecewise linear approximation, or \code{'constant'} for a
piecewise constant curve.}
}
\value{
Implicit spot curve based on the input forward rates and input term
structure.
}
\description{
Uses a recursive method to calculate the implicit spot rates of
a given forward curve. Calculations and formulas based on the definition of
forward rates where \eqn{\exp{-rT} = \exp{-\int{f(t)dt}}}.
}
\details{
Requires continuous rates. Recommended that the input forward curve
starts with maturity 0, if not, function will approximate zero node
as equal to node 1 (first term structure). Output forward
curve slightly differs from empirical curve as it calculates an implicit
forward curve.
}
\examples{
# Inputs for calibration of forward curve
yield.curve <- c(0.015,0.0175, 0.0225, 0.0275, 0.0325, 0.0375,0.04,0.0425,0.045,0.0475,0.05)
names(yield.curve) <- c(0.5,1,2,3,4,5,6,7,8,9,10)
nodes <- seq(0,10,0.5)
# Calibration
fwd <- curve.calibration (yield.curve = yield.curve, market.assets = NULL,
                          analysis.date = "2019-01-03", asset.type = "IBRSwaps",
                          freq = 4, rate.type = 0, daycount = "ACT/365",  fwd = 1,
                          npieces = NULL, nodes = nodes, approximation = "constant")
# Forward to Spot
dates <- names(fwd)
fwd2spot(dates, fwd, approximation = "constant")

}
