% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareQuartets.R
\name{CompareQuartetsMulti}
\alias{CompareQuartetsMulti}
\title{Compare one tree's quartets against others'}
\usage{
CompareQuartetsMulti(x, cf)
}
\arguments{
\item{x}{Object of class \code{phylo} representing the tree of interest.}

\item{cf}{Comparison tree of class \code{phylo}, or list thereof, each with the
same leaves as \code{x}.}
}
\value{
\code{CompareQuartetsMulti()} returns a named integer vector specifying
the number of quartets whose resolution in \code{x} matches all or any of the
resolutions in \code{cf}.

Named elements are:

\describe{
\item{N}{The total number of quartet \emph{statements} for the given number of
\emph{n}-leaf trees, i.e. \emph{n_trees} × \emph{Q}.}
\item{Q}{The total number of quartets for \emph{n} leaves.}
\item{s_all}{The number of quartets that are resolved identically in all
trees.}
\item{s_any}{The number of quartets that are resolved in \code{x}, and
identically in at least one of \code{cf}.}
\item{d_all}{The number of quartets that are resolved in every tree in
\code{cf}, but never in the same way as they are resolved in in \code{x}.}
\item{d_any}{The number of quartets in \code{x} that are resolved differently
(i.e. contradicted) in at least one tree in \code{cf}.}
\item{r1_all}{The number of quartets that are resolved in \code{x}, but not in
any of \code{cf}.}
\item{r1_any}{The number of quartets that are resolved in \code{x}, but
unresolved in at least one of \code{cf}.}
\item{r2_all}{The number of quartets that are resolved in all of \code{cf},
but not in \code{x}.}
\item{r2_any}{The number of quartets that are resolved in at least one of \code{cf},
but not in \code{x}.}
\item{u_all}{The number of quartets that are unresolved in all trees.}
\item{u_any}{The number of quartets that are unresolved in \code{x} and
at least one tree in \code{cf}.}
\item{x_only}{The number of quartets in \code{x} that are not resolved the
same way in any of \code{cf}.}
}
}
\description{
\code{CompareQuartetsMulti()} counts how many quartets in one tree are resolved
in the same way or different ways in a forest of comparison trees.
}
\details{
\code{CompareQuartetsMulti()} explicitly evaluates each quartet in each tree.
As such its runtime will increase hyper-exponentially with the number of
leaves in trees being compared.  30 leaves will take around 5 seconds;
40 closer to 20 s, and 50 around a minute.
}
\examples{
library("TreeTools")
CompareQuartetsMulti(x  = CollapseNode(as.phylo(42, 6), 8:9),
                     cf = list(BalancedTree(6), PectinateTree(6), 
                               CollapseNode(as.phylo(1337, 6), 9:10)))

}
\seealso{
Other element-by-element comparisons: 
\code{\link{CompareQuartets}()},
\code{\link{CompareSplits}()},
\code{\link{PairSharedQuartetStatus}()},
\code{\link{QuartetState}()},
\code{\link{SharedQuartetStatus}()},
\code{\link{SplitStatus}()}

Other quartet counting functions: 
\code{\link{AllQuartets}()},
\code{\link{CompareQuartets}()},
\code{\link{ResolvedQuartets}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{element-by-element comparisons}
\concept{quartet counting functions}
