% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmsolve.R
\docType{data}
\name{glmSolvers}
\alias{glmSolvers}
\alias{glmSolve}
\alias{glmsolve}
\title{Generalized linear model (glm) solvers}
\format{\code{glmSolvers} is currently a list of length 4. See 
\code{solvers} argument for details and the example.}
\usage{
glmSolvers

glmsolve(formula, family = gaussian, data, control = list(...),
  solvers = glmSolvers, ...)
}
\arguments{
\item{formula, family, data}{Identical to those of \code{\link{glm}}.}

\item{control}{A list of named control options that specifies the 
details for each solver. Named elements not used by any solver will 
be ignored.}

\item{solvers}{A named list of glm solvers, default to \code{glmSolvers}. 
Each element is itself 
a list with components named \code{solve}, \code{success}, and 
\code{result}, each of which is an expression. \code{solve} is an 
expression used to fit the glm model, the result of which is assigned
to an object \code{ans}. \code{success} is an expression that returns a 
logical scalar, indicating whether the solver has succeeded. It may 
refer to the \code{ans} returned by \code{solve}. Often, it will check 
the \code{converged} element of \code{ans}, or something similar. 
\code{result} is an expression that returns a \code{glm} object from 
the success solver. If the \code{solver} does not return a \code{glm} 
object, it is the duty of \code{result} expression to convert it to a 
\code{glm} object.}

\item{...}{Additional arguments passed to solvers.}
}
\value{
If at least one of the solvers succeed, an \code{glm} object
will be returned from the success. If all solvers fail but at least 
one solver did not throw an error, the result from the last solver 
that did not throw an error will be returned. In this case, 
\code{glmsolve} will throw a warning, stating that none of the solvers
succeeded. If all solvers ended up throwing errors, \code{glmsolve} 
will also throw an error, again stating that non of the solvers 
succeeded.
}
\description{
\code{glmsolve} sequencially tries multiple glm solvers and returns the 
result from the success. This tries to avoid numerical instabilities
that occassionally affect some glm solving routines. If one fails, the 
next solver will be tried.
}
\details{
Currently, the supported are solvers are \code{c('glm', 'glm.fit3', 
'nlminb', 'BFGS')}. \code{'glm'} is the one that comes with the default
\code{stats} package. \code{'glm.fit3'} is a modification with better 
stability (but slightly slower). \code{'nlminb'} uses the general 
optimization routine \code{\link[stats]{nlminb}}. \code{'BFGS'} uses 
the \code{method='BFGS'} option provided by \code{\link{optim}}.
}
\examples{
str(glmSolvers) ## available solvers stored in glmSolvers object
## Taken from stats::glm:
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
print(d.AD <- data.frame(treatment, outcome, counts))
glm.D93 <- glmsolve(counts ~ outcome + treatment, family = poisson())

}
\seealso{
\code{\link[stats]{glm}}, \code{\link[stats]{nlminb}}, 
\code{\link[stats]{optim}}, \code{\link{nlsolve}}
}
\author{
Long Qu
}
\keyword{datasets}
\keyword{iteration}
