% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_workflows.R
\name{growth.workflow}
\alias{growth.workflow}
\title{Run a complete growth curve analysis and dose-reponse analysis workflow.}
\usage{
growth.workflow(
  grodata = NULL,
  time = NULL,
  data = NULL,
  ec50 = TRUE,
  mean.grp = NA,
  mean.conc = NA,
  neg.nan.act = FALSE,
  clean.bootstrap = TRUE,
  suppress.messages = FALSE,
  fit.opt = c("a"),
  t0 = 0,
  tmax = NA,
  min.growth = NA,
  max.growth = NA,
  log.x.gc = FALSE,
  log.y.lin = TRUE,
  log.y.spline = TRUE,
  log.y.model = TRUE,
  biphasic = FALSE,
  lin.h = NULL,
  lin.R2 = 0.97,
  lin.RSD = 0.1,
  lin.dY = 0.05,
  interactive = FALSE,
  nboot.gc = 0,
  smooth.gc = 0.55,
  model.type = c("logistic", "richards", "gompertz", "gompertz.exp", "huang", "baranyi"),
  dr.method = c("model", "spline"),
  dr.model = c("gammadr", "multi2", "LL.2", "LL.3", "LL.4", "LL.5", "W1.2", "W1.3",
    "W1.4", "W2.2", "W2.3", "W2.4", "LL.3u", "LL2.2", "LL2.3", "LL2.3u", "LL2.4",
    "LL2.5", "AR.2", "AR.3", "MM.2"),
  growth.thresh = 1.5,
  dr.have.atleast = 6,
  dr.parameter = c("mu.linfit", "lambda.linfit", "dY.linfit", "A.linfit", "mu.spline",
    "lambda.spline", "dY.spline", "A.spline", "mu.model", "lambda.model",
    "dY.orig.model", "A.orig.model"),
  smooth.dr = 0.1,
  log.x.dr = FALSE,
  log.y.dr = FALSE,
  nboot.dr = 0,
  report = NULL,
  out.dir = NULL,
  out.nm = NULL,
  export.fig = FALSE,
  export.res = FALSE,
  parallelize = TRUE,
  ...
)
}
\arguments{
\item{grodata}{A \code{grodata} object created with \code{\link{read_data}} or \code{\link{parse_data}}, or a list containing a \code{'time'} matrix as well as a \code{'growth'} dataframe.}

\item{time}{(optional) A matrix containing time values for each sample.}

\item{data}{(optional) A dataframe containing growth data (if a \code{time} matrix is provided as separate argument).}

\item{ec50}{(Logical) Perform dose-response analysis (\code{TRUE}) or not (\code{FALSE}).}

\item{mean.grp}{(\code{'all'}, a string vector, or a list of string vectors) Define groups to combine into common plots in the final report based on sample identifiers (if \code{report == TRUE}). Partial matches with sample/group names are accepted. Note: The maximum number of sample groups (with unique condition/concentration indicators) is 50. If you have more than 50 groups, option \code{'all'} will produce the error \code{! Insufficient values in manual scale. [Number] needed but only 50 provided}.}

\item{mean.conc}{(A numeric vector, or a list of numeric vectors) Define concentrations to combine into common plots in the final report (if \code{report == TRUE}).}

\item{neg.nan.act}{(Logical) Indicates whether the program should stop when negative growth values or NA values appear (\code{TRUE}). Otherwise, the program removes these values silently (\code{FALSE}). Improper values may be caused by incorrect data or input errors. Default: \code{FALSE}.}

\item{clean.bootstrap}{(Logical) Determines if negative values which occur during bootstrap should be removed (TRUE) or kept (FALSE). Note: Infinite values are always removed. Default: TRUE.}

\item{suppress.messages}{(Logical) Indicates whether grofit messages (information about current growth curve, EC50 values etc.) should be displayed (\code{FALSE}) or not (\code{TRUE}). This option is meant to speed up the high-throughput processing data. Note: warnings are still displayed. Default: \code{FALSE}.}

\item{fit.opt}{(Character or character vector) Indicates whether the program should perform a linear regression (\code{'l'}), model fit (\code{'m'}), spline fit (\code{'s'}), or all (\code{'a'}). Combinations can be freely chosen by providing a character vector, e.g. \code{fit.opt = c('l', 's')} Default:  \code{fit.opt = c('l', 's')}.}

\item{t0}{(Numeric) Minimum time value considered for linear and spline fits.}

\item{tmax}{(Numeric) Maximum time value considered for linear and spline fits.}

\item{min.growth}{(Numeric) Indicate whether only growth values above a certain threshold should be considered for linear regressions or spline fits.}

\item{max.growth}{(Numeric) Indicate whether only growth values below a certain threshold should be considered for linear regressions or spline fits.}

\item{log.x.gc}{(Logical) Indicates whether \emph{ln(x+1)} should be applied to the time data for \emph{linear} and \emph{spline} fits. Default: \code{FALSE}.}

\item{log.y.lin}{(Logical) Indicates whether \emph{ln(y/y0)} should be applied to the growth data for \emph{linear} fits. Default: \code{TRUE}}

\item{log.y.spline}{(Logical) Indicates whether \emph{ln(y/y0)} should be applied to the growth data for \emph{spline} fits. Default: \code{TRUE}}

\item{log.y.model}{(Logical) Indicates whether \emph{ln(y/y0)} should be applied to the growth data for \emph{model} fits. Default: \code{TRUE}}

\item{biphasic}{(Logical) Shall \code{\link{growth.gcFitLinear}} and \code{\link{growth.gcFitSpline}} try to extract growth parameters for two different growth phases (as observed with, e.g., diauxic shifts) (\code{TRUE}) or not (\code{FALSE})?}

\item{lin.h}{(Numeric) Manually define the size of the sliding window used in \code{\link{growth.gcFitLinear}} If \code{NULL}, h is calculated for each samples based on the number of measurements in the growth phase of the plot.}

\item{lin.R2}{(Numeric) \ifelse{html}{\out{R<sup>2</sup>}}{\eqn{R^2}} threshold for \code{\link{growth.gcFitLinear}}}

\item{lin.RSD}{(Numeric) Relative standard deviation (RSD) threshold for calculated slope in \code{\link{growth.gcFitLinear}}}

\item{lin.dY}{(Numeric) Threshold for the minimum fraction of growth increase a linear regression window should cover. Default: 0.05 (5\%).}

\item{interactive}{(Logical) Controls whether the fit of each growth curve and method is controlled manually by the user. If \code{TRUE}, each fit is visualized in the \emph{Plots} pane and the user can adjust fitting parameters and confirm the reliability of each fit per sample. Default: \code{TRUE}.}

\item{nboot.gc}{(Numeric) Number of bootstrap samples used for nonparametric growth curve fitting with \code{\link{growth.gcBootSpline}}. Use \code{nboot.gc = 0} to disable the bootstrap. Default: \code{0}}

\item{smooth.gc}{(Numeric) Parameter describing the smoothness of the spline fit; usually (not necessary) within (0;1]. \code{smooth.gc=NULL} causes the program to query an optimal value via cross validation techniques. Especially for datasets with few data points the option NULL might cause a too small smoothing parameter. This can result a too tight fit that is susceptible to measurement errors (thus overestimating growth rates) or produce an error in \code{smooth.spline} or lead to an overestimation. The usage of a fixed value is recommended for reproducible results across samples. See \code{?smooth.spline} for further details. Default: \code{0.55}}

\item{model.type}{(Character) Vector providing the names of the parametric models which should be fitted to the data. Default: \code{c('logistic', 'richards', 'gompertz', 'gompertz.exp', 'huang', 'baranyi')}.}

\item{dr.method}{(Character) Define the method used to perform a dose-responde analysis: smooth spline fit (\code{'spline'}) or model fitting (\code{'model'}).}

\item{dr.model}{(Character) Provide a list of models from the R package 'drc' to include in the dose-response analysis (if \code{dr.method = 'model'}). If more than one model is provided, the best-fitting model will be chosen based on the Akaike Information Criterion.}

\item{growth.thresh}{(Numeric) Define a threshold for growth. Only if any growth value in a sample is greater than \code{growth.thresh} (default: 1.5) times the start growth, further computations are performed. Else, a message is returned.}

\item{dr.have.atleast}{(Numeric) Minimum number of different values for the response parameter one should have for estimating a dose response curve. Note: All fit procedures require at least six unique values. Default: \code{6}.}

\item{dr.parameter}{(Character or numeric) The response parameter in the output table to be used for creating a dose response curve. See \code{\link{growth.drFit}} for further details. Default: \code{'mu.linfit'}, which represents the maximum slope of the linear regression. Typical options include: \code{'mu.linfit'}, \code{'lambda.linfit'}, \code{'dY.linfit'}, \code{'mu.spline'}, \code{'dY.spline'}, \code{'mu.model'}, and \code{'A.model'}.}

\item{smooth.dr}{(Numeric) Smoothing parameter used in the spline fit by smooth.spline during dose response curve estimation. Usually (not necessesary) in (0; 1]. See documentation of smooth.spline for further details. Default: \code{NULL}.}

\item{log.x.dr}{(Logical) Indicates whether \code{ln(x+1)} should be applied to the concentration data of the dose response curves. Default: \code{FALSE}.}

\item{log.y.dr}{(Logical) Indicates whether \code{ln(y+1)} should be applied to the response data of the dose response curves. Default: \code{FALSE}.}

\item{nboot.dr}{(Numeric) Defines the number of bootstrap samples for EC50 estimation. Use \code{nboot.dr = 0} to disable bootstrapping. Default: \code{0}.}

\item{report}{(Character or NULL) Create a PDF (\code{'pdf'}) and/or HTML (\code{'html'}) report after running all computations. Define \code{NULL} if no report should be created. Default: (\code{c('pdf', 'html')})}

\item{out.dir}{{Character or \code{NULL}} Define the name of a folder in which all result files are stored. If \code{NULL}, the folder will be named with a combination of 'GrowthResults_' and the current date and time.}

\item{out.nm}{{Character or \code{NULL}} Define the name of the report files. If \code{NULL}, the files will be named with a combination of 'GrowthReport_' and the current date and time.}

\item{export.fig}{(Logical) Export all figures created in the report as separate PNG and PDF files (\code{TRUE}) or not (\code{FALSE}). Only effective if \code{report != NULL}.}

\item{export.res}{(Logical) Create tab-separated TXT files containing calculated growth parameters and dose-response analysis results as well as an .RData file for the resulting \code{grofit} object.}

\item{parallelize}{Run linear fits and bootstrapping operations in parallel using all but one available processor cores}

\item{...}{Further arguments passed to the shiny app.}
}
\value{
A \code{grofit} object that contains all computation results, compatible with various plotting functions of the QurvE package and with \code{\link{growth.report}}.
\item{time}{Raw time matrix passed to the function as \code{time} (if no \code{grofit} object is provided).}
\item{data}{Raw growth dataframe passed to the function as \code{data} (if no \code{grofit} object is provided).}
\item{gcFit}{\code{gcFit} object created with the call of \code{\link{growth.gcFit}}.}
\item{drFit}{\code{drFit} object created with the call of \code{\link{growth.drFit}}.}
\item{expdesign}{Experimental design table inherited from \code{grodata} or created from the identifier columns (columns 1-3) in \code{data}.}
\item{control}{Object of class \code{grofit.control} created with the call of \code{\link{growth.control}}.}
}
\description{
\code{growth.workflow} runs \code{\link{growth.control}} to create a \code{grofit.control} object and then performs all computational fitting operations based on the user input. Finally, if desired, a final report is created in PDF or HTML format that summarizes all results obtained.
}
\details{
Common response parameters used in dose-response analysis:\if{html}{\out{<br>}}\if{html}{\out{<br>}}\if{html}{\out{<b>}}Linear fit:\if{html}{\out{</b>}}\if{html}{\out{<br>}}- mu.linfit: Growth rate\if{html}{\out{<br>}}- lambda.linfit: Lag time\if{html}{\out{<br>}}- dY.linfit: Density increase\if{html}{\out{<br>}}- A.linfit: Maximum measurement\if{html}{\out{<br>}}\if{html}{\out{<br>}}\if{html}{\out{<b>}}Spline fit:\if{html}{\out{</b>}}\if{html}{\out{<br>}}- mu.spline: Growth rate\if{html}{\out{<br>}}- lambda.spline: Lag time\if{html}{\out{<br>}}- A.spline: Maximum measurement\if{html}{\out{<br>}}- dY.spline: Density increase\if{html}{\out{<br>}}- integral.spline: Integral\if{html}{\out{<br>}}\if{html}{\out{<br>}}\if{html}{\out{<b>}}Parametric fit:\if{html}{\out{</b>}}\if{html}{\out{<br>}}- mu.model: Growth rate\if{html}{\out{<br>}}- lambda.model: Lag time\if{html}{\out{<br>}}- A.model: Maximum measurement\if{html}{\out{<br>}}- integral.model: Integral'
}
\examples{
# Create random growth data set
  rnd.data1 <- rdm.data(d = 35, mu = 0.8, A = 5, label = 'Test1')
  rnd.data2 <- rdm.data(d = 35, mu = 0.6, A = 4.5, label = 'Test2')

  rnd.data <- list()
  rnd.data[['time']] <- rbind(rnd.data1$time, rnd.data2$time)
  rnd.data[['data']] <- rbind(rnd.data1$data, rnd.data2$data)

  # Run growth curve analysis workflow
  res <- growth.workflow(time = rnd.data$time,
                         data = rnd.data$data,
                         fit.opt = 's',
                         ec50 = FALSE,
                         export.res = FALSE,
                         suppress.messages = TRUE,
                         parallelize = FALSE)

# Load custom dataset
  input <- read_data(data.growth = system.file('2-FMA_toxicity.csv', package = 'QurvE'))

  res <- growth.workflow(grodata = input,
                         fit.opt = 's',
                         ec50 = TRUE,
                         export.res = FALSE,
                         suppress.messages = TRUE,
                         parallelize = FALSE)

  plot(res)

}
\seealso{
Other workflows: 
\code{\link{flFit}()},
\code{\link{growth.gcFit}()}

Other growth fitting functions: 
\code{\link{growth.drFit}()},
\code{\link{growth.gcBootSpline}()},
\code{\link{growth.gcFitLinear}()},
\code{\link{growth.gcFitModel}()},
\code{\link{growth.gcFitSpline}()},
\code{\link{growth.gcFit}()}

Other dose-response analysis functions: 
\code{\link{flFit}()},
\code{\link{growth.drBootSpline}()},
\code{\link{growth.drFitSpline}()},
\code{\link{growth.gcFit}()}
}
\concept{dose-response analysis functions}
\concept{growth fitting functions}
\concept{workflows}
