% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_fits.R
\name{flFitSpline}
\alias{flFitSpline}
\title{Perform a smooth spline fit on fluorescence data}
\usage{
flFitSpline(
  time = NULL,
  growth = NULL,
  fl_data,
  ID = "undefined",
  control = fl.control(biphasic = FALSE, x_type = c("growth", "time"), log.x.spline =
    FALSE, log.y.spline = FALSE, smooth.fl = 0.75, t0 = 0, min.growth = NA)
)
}
\arguments{
\item{time}{Vector of the independent variable: time (if \code{x_type = 'time'} in \code{fl.control} object.}

\item{growth}{Vector of the independent variable: growth (if \code{x_type = 'growth'} in \code{fl.control} object.}

\item{fl_data}{Vector of dependent variable: fluorescence.}

\item{ID}{(Character) The name of the analyzed sample.}

\item{control}{A \code{fl.control} object created with \code{\link{fl.control}}, defining relevant fitting options.}

\item{biphasic}{(Logical) Shall \code{\link{flFitLinear}} and \code{\link{flFitSpline}} try to extract fluorescence parameters for two different phases (as observed with, e.g., regulator-promoter systems with varying response in different growth stages) (\code{TRUE}) or not (\code{FALSE})?}

\item{x_type}{(Character) Which data type shall be used as independent variable? Options are \code{'growth'} and \code{'time'}.}

\item{log.x.spline}{(Logical) Indicates whether \emph{ln(x+1)} should be applied to the independent variable for \emph{spline} fits. Default: \code{FALSE}.}

\item{log.y.spline}{(Logical) Indicates whether \emph{ln(y/y0)} should be applied to the fluorescence data for \emph{spline} fits. Default: \code{FALSE}}

\item{smooth.fl}{(Numeric) Parameter describing the smoothness of the spline fit; usually (not necessary) within (0;1]. \code{smooth.gc=NULL} causes the program to query an optimal value via cross validation techniques. Especially for datasets with few data points the option \code{NULL} might cause a too small smoothing parameter. This can result a too tight fit that is susceptible to measurement errors (thus overestimating slopes) or produce an error in \code{\link{smooth.spline}} or lead to overfitting. The usage of a fixed value is recommended for reproducible results across samples. See \code{\link{smooth.spline}} for further details. Default: \code{0.55}}

\item{t0}{(Numeric) Minimum time value considered for linear and spline fits.}

\item{min.growth}{(Numeric) Indicate whether only values above a certain threshold should be considered for linear regressions or spline fits.}
}
\value{
A \code{flFitSpline} object. The lag time is estimated as the intersection between the
tangent at the maximum slope and the horizontal line with \eqn{y = y_0}, where
\code{y0} is the first value of the dependent variable. Use \code{\link{plot.flFitSpline}} to
visualize the spline fit and derivative over time.
\item{x.in}{Raw x values provided to the function as \code{time} or \code{growth}.}
\item{fl.in}{Raw fluorescence data provided to the function as \code{fl_data}.}
\item{raw.x}{Filtered x values used for the spline fit.}
\item{raw.fl}{Filtered fluorescence values used for the spline fit.}
\item{ID}{(Character) Identifies the tested sample.}
\item{fit.x}{Fitted x values.}
\item{fit.fl}{Fitted fluorescence values.}
\item{parameters}{List of determined parameters.}
\itemize{
\item \code{A}: {Maximum fluorescence.}
\item \code{dY}: {Difference in maximum fluorescence and minimum fluorescence.}
\item \code{max_slope}: {Maximum slope of fluorescence-vs.-x data (i.e., maximum in first derivative of the spline).}
\item \code{x.max}: {Time at the maximum slope.}
\item \code{lambda}: {Lag time.}
\item \code{b.tangent}: {Intersection of the tangent at the maximum slope with the abscissa.}
\item \code{max_slope2}: {For biphasic course of fluorescence: Maximum slope of fluorescence-vs.-x data of the second phase.}
\item \code{lambda2}: {For biphasic course of fluorescence: Lag time determined for the second phase.}
\item \code{x.max2}: {For biphasic course of fluorescence: Time at the maximum slope of the second phase.}
\item \code{b.tangent2}: {For biphasic course of fluorescence: Intersection of the tangent at the maximum slope of the second phase with the abscissa.}
\item \code{integral}: {Area under the curve of the spline fit.}
}
\item{spline}{\code{smooth.spline} object generated by the \code{\link{smooth.spline}} function.}
\item{spline.deriv1}{list of time ('x') and growth ('y') values describing the first derivative of the spline fit.}
\item{reliable}{(Logical) Indicates whether the performed fit is reliable (to be set manually).}
\item{fitFlag}{(Logical) Indicates whether a spline fit was successfully performed on the data.}
\item{fitFlag2}{(Logical) Indicates whether a second phase was identified.}
\item{control}{Object of class \code{fl.control} containing list of options passed to the function as \code{control}.}
}
\description{
\code{flFitSpline} performs a smooth spline fit on the dataset and determines
the greatest slope as the global maximum in the first derivative of the spline.
}
\details{
If \code{biphasic = TRUE}, the following steps are performed to define a
second phase: \enumerate{ \item Determine local minima within the first
derivative of the smooth spline fit. \item Remove the 'peak' containing the highest
value of the first derivative (i.e., \eqn{mu_{max}}) that is flanked by two local
minima. \item Repeat the smooth spline fit and identification of maximum slope for
later time values than the local minimum after \eqn{mu_{max}}. \item Repeat the
smooth spline fit and identification of maximum slope for earlier time values than
the local minimum before \eqn{mu_{max}}. \item Choose the greater of the two
independently determined slopes as \eqn{mu_{max}2}. }
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters_growth.txt", package = "QurvE"),
                   data.fl = system.file("lac_promoters_fluorescence.txt", package = "QurvE"),
                   csvsep = "\t",
                   csvsep.fl = "\t")

# Extract time and normalized fluorescence data for single sample
time <- input$time[4,]
data <- input$norm.fluorescence[4,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- flFitSpline(time = time,
                       fl_data = data,
                       ID = 'TestFit',
                       control = fl.control(fit.opt = 's', x_type = 'time'))

plot(TestFit)
}
\seealso{
Other fluorescence fitting functions: 
\code{\link{flBootSpline}()},
\code{\link{flFit}()}
}
\concept{fluorescence fitting functions}
