% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QvalIndex.R
\name{zVRR}
\alias{zVRR}
\title{Calculate Vector Recovery Ratio (VRR)}
\usage{
zVRR(Q.true, Q.sug)
}
\arguments{
\item{Q.true}{The true Q-matrix.}

\item{Q.sug}{The Q-matrix that has been validated.}
}
\value{
A numeric (VRR index).
}
\description{
Calculate Vector Recovery Ratio (VRR)
}
\details{
The VRR shows the ability of the validation method to recover q-vectors, and is determined by
\deqn{
 VRR =\frac{\sum_{i=1}^{I}I(\mathbf{q}_{i}^{t} = \mathbf{q}_{i}^{s})}{I}
}
where \eqn{\mathbf{q}_{i}^{t}} denotes the \eqn{\mathbf{q}}-vector of item \eqn{i} in the true Q-matrix (\code{Q.true}),
\eqn{\mathbf{q}_{i}^{s}} denotes the \eqn{\mathbf{q}}-vector of item \eqn{i} in the suggested Q-matrix(\code{Q.sug}),
and \eqn{I(\cdot)} is the indicator function.
}
\examples{
library(Qval)

set.seed(123)

Q1 <- sim.Q(5, 30)
Q2 <- sim.MQ(Q1, 0.1)
VRR <- zVRR(Q1, Q2)
print(VRR)

}
