% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepThsd.R
\name{sepThsd}
\alias{sepThsd}
\title{Quick Number Formatting with Custom Defaults}
\usage{
sepThsd(x, big.mark = " ", digits = 1, scientific = FALSE)
}
\arguments{
\item{x}{Numeric. The input values to format.}

\item{big.mark}{Character. The separator for thousands
(e.g., `" "` for "1 000" or `","` for "1,000"). Default is `" "`.}

\item{digits}{Integer. The number of significant digits to display.
Default is `1`.}

\item{scientific}{Logical. Should the numbers be displayed in scientific
notation? Default is `FALSE`.}
}
\value{
A character vector of formatted numbers.
}
\description{
A wrapper for the `format` function, designed to format numbers
with custom defaults for thousands separator, number of significant digits,
and scientific notation.
}
\examples{
# Format with a comma as a thousands separator and 3 significant digits
sepThsd(1234567.89, big.mark = ",", digits = 3)
# Use scientific notation
sepThsd(1234567.89, scientific = TRUE)

}
