% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Postprocessing.R
\name{prepareOutput}
\alias{prepareOutput}
\title{Prepare output (useful for all postprocessing analysis)}
\usage{
prepareOutput(
  sambadaname,
  dimMax,
  gdsFile = NULL,
  popStr = FALSE,
  nrows = NULL,
  interactiveChecks = TRUE
)
}
\arguments{
\item{sambadaname}{char The name of the genofile without extension name given to sambada (or outputfile of sambada without the ending -Out-Dim.csv)}

\item{dimMax}{integer The maximum number of dimension given in sambada}

\item{gdsFile}{char Name of the gds file associated with sambada's input file. If null, will try with \code{sambadaname}.gds}

\item{popStr}{logical Indicates whether sambada was run using the POPSTRVAR parameter (i.e. population structure was taken into account). Default false}

\item{nrows}{integer Specifies the number of line to read from the input file. Useful if \code{saveType} 'END ALL' was used in \code{sambadaParallel} and that the number of models run is large so that the reading and processing is too slow. The \code{saveType} 'END' parameter ensures that most significant models are located at the top of the file.}

\item{interactiveChecks}{logical If TRUE, plots showing the distribution of p-values and estimates of pi0 (to adjust q-values) will be drawn. According to Storey's method to calculate q-values (Storey, J. D. (2003). The positive false discovery rate: a Bayesian interpretation and the q-value. The Annals of Statistics, 31(6), 2013-2035), you need to estimate a pi0 parameter which can be derived from an histogram of p-values. Pi0 correponds to the limit when p-value -> 1. The histogram should reach a plateau with increasing p-value. It this is not the case, q-values might not be the best option to correct for multiple testing.}
}
\value{
a list containing a) \code{$sambadaOutput} a matrix containing the output from sambada with 3 additional column: corresponding snp, chromosome and position of the marker b) \code{$chrSNPNum} The total number of SNPs in each chromosome c) \code{$chrMaxPos} The highest position found in each chromosome
}
\description{
Read sambada's output and prepare it by retrieving the snp position and chromosome (useful for plotting manhattan)
}
\examples{
# Example with data from the package
# First copy needed files into the temporary directory
file.copy(system.file("extdata", "uganda-subset-mol-Out-2.csv", package = "R.SamBada"), 
     file.path(tempdir(),'uganda-subset-mol-Out-2.csv'), overwrite=TRUE)
file.copy(system.file("extdata", "uganda-subset-mol-storey.csv", package = "R.SamBada"), 
     file.path(tempdir(),'uganda-subset-mol-storey.csv'), overwrite=TRUE)
if(Sys.info()['sysname']=='Windows'){
  file.copy(system.file("extdata", "uganda-subset-mol_windows.gds", package = "R.SamBada"),
      file.path(tempdir(),'uganda-subset-mol.gds'), overwrite=TRUE) #If you run Windows
} else {
  file.copy(system.file("extdata", "uganda-subset-mol_unix.gds", package = "R.SamBada"),
      file.path(tempdir(),'uganda-subset-mol.gds'), overwrite=TRUE)
}
###################
# Run prepareOutput
###################
prep=prepareOutput(file.path(tempdir(),'uganda-subset-mol'),2,popStr=TRUE,
     interactiveChecks=FALSE)
}
\author{
Solange Duruz, Sylvie Stucki
}
