###########################################################################/**
# @RdocClass RccViolationException
#
# @title "An RccViolationException indicates a violation of the R Coding Conventions (RCC)"
#
# \description{
#  @classhierarchy
#
#  @get "title".
#  It is generated by \code{setConstructorS3()} and \code{setMethodS3()}.
#  It is \emph{not} meant to be caught, but instead the source code that
#  violates the RCC should be fixed. For more information about RCC, see
#  references below.
# }
#
# @synopsis
#
# \arguments{
#   \item{...}{Any arguments accepted by the constructor of Exception, i.e.
#     one or several @character strings, which will be concatenated and
#     contain informative message about why the RCC was violated.}
# }
#
# \section{Fields and Methods}{
#  @allmethods
# }
#
# \details{
#   Since it is not possible to assert that the RCC is followed during the
#   parsing of the source code, but first only when the source code is
#   actually executed.
# }
#
# \examples{
#  \dontrun{
#   setConstructorS3("myClass", function() { extends(Object(), .value=0) })
#   setMethodS3("MyMethod", "myClass", function(this) { "Hullo!" })
#  }
# }
#
# @author
#
# \seealso{
#   See also @see "base::try" and \code{\link[base:conditions]{tryCatch}()}.
#   For detailed information about exceptions see @see "Exception".
#   The R Coding Conventions (RCC) can be found at
#   \url{@eval "RccViolationException$getRccUrl()"}.
# }
#
# @keyword programming
# @keyword methods
# @keyword error
# @keyword internal
#*/###########################################################################
setConstructorS3("RccViolationException", function(...) {
  extend(Exception(...), c("RccViolationException")
  )
})





###########################################################################/**
# @RdocMethod as.character
#
# @title "Gets a string representing of the RCC violation"
#
# \description{
#  @get "title" of format "[\{POSIX date string\}] \{class name\}: \{msg\}, cf. @eval "RccViolationException$getRccUrl()"".
# }
#
# @synopsis
#
# \arguments{
#   \item{...}{Not used.}
# }
#
# \value{
#  Returns a @character string.
# }
#
# \examples{\dontrun{For a complete example see help(Exception).}}
#
# @author
#
# \seealso{
#   @seeclass
# }
#
# \keyword{programming}
# \keyword{methods}
# \keyword{error}
#*/###########################################################################
setMethodS3("as.character", "RccViolationException", function(x, ...) {
  # To please R CMD check
  this <- x

  paste("[", getWhen(this), "] ", class(this)[1L], ": ", getMessage(this), ", cf. ", getRccUrl(this), sep="")
})




###########################################################################/**
# @RdocMethod getRccUrl
#
# @title "Static method to get a URL where the RCC can be found"
#
# \description{
#  Static method to get a URL where one can find details about the
#  R Code Convention (RCC).
#  Currently the URL is \url{@eval "RccViolationException$getRccUrl()"}.
# }
#
# @synopsis
#
# \arguments{
#   \item{...}{Not used.}
# }
#
# \value{
#  Returns a @character string.
# }
#
# \examples{\dontrun{For a complete example see help(RccViolationException).}}
#
# @author
#
# \seealso{
#   @seeclass
# }
#
# \keyword{programming}
# \keyword{methods}
# \keyword{error}
#*/###########################################################################
setMethodS3("getRccUrl", "RccViolationException", function(this, ...) {
  "http://aroma-project.org/developers/RCC/"
}, static=TRUE)
