%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  abort.R
% 
% by the Rdoc compiler part of the R.oo package.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{abort}
\alias{abort.default}
\alias{abort}
\alias{abort.condition}

\title{Aborts the current expression call}

\description{
 Aborts the current expression call and returns to the top level prompt/browser
 \emph{without signalling a condition}.
}

\usage{\method{abort}{default}(message, call=NULL, ...)}

\arguments{
  \item{message}{A \code{\link[base]{character}} string giving the abort message.}
  \item{call}{An optional call \code{\link[base]{expression}}.}
  \item{...}{Not used.}
}

\value{
  Returns nothing.
}

\examples{\dontrun{
 foo <- function() {
  tryCatch({
    stop("Woops!")
  }, error = function(ex) {
    cat("An error was caught: ", ex$message, "\n", sep="")
  })
  cat("Continuing...\n");
}

bar <- function() {
  tryCatch({
    abort("Woops!")
  }, error = function(ex) {
    cat("An error was caught: ", ex$message, "\n", sep="")
  })
  cat("This message will never be displayed...\n");
}

# An error generated by stop() can be caught
foo()

# ...which is not possible when using abort()
bar()

}}

\author{Henrik Bengtsson (\url{http://www.braju.com/R/})}

\seealso{
  \code{\link{throw}}().
  \code{\link[base]{stop}}().
}



\keyword{error}
\keyword{internal}
