% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{r2_mc}
\alias{r2_mc}
\title{Posterior distribution of McFadden's R2}
\usage{
r2_mc(Y, out)
}
\arguments{
\item{Y}{ordinal response}

\item{out}{posterior samples from R2D2 model fit in Stan}
}
\value{
Posterior samples from McFadden's R2
}
\description{
This function finds the posterior distribution of
McFadden's R2 given the posterior samples from a Stan model fit
}
\examples{
\donttest{
# Obtain output from ord_r2d2() model fit
set.seed(1234)
# X are covariates, Y are responses, K is number of response categories
# This example will yield low R2 values as the response are independent of the covariates.
n = 100
p = 5
X = matrix(rnorm(n*p), nrow = n, ncol=p)
K = 3
Y = sample(1:K, 100, replace=TRUE)
a = 1
b = 5
# Pre-computed hyperparameters
fit <- ord_r2d2(X, Y, K, hyper=c(0.002, 0.989, 1.013), no_cores=1)
out <- rstan::extract(fit)
# Plot histogram of posterior R2
hist(r2_mc(Y, out), xlab="R2")
}
}
