% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeReference.R
\name{MakeReference}
\alias{MakeReference}
\title{This function takes input chromatof files from metabolite standards and parses them into a dataframe of retention time indexed standards that can be used as an input for ConsensusAlign function}
\usage{
MakeReference(inputFileList, RT1_Standards = NULL, RT2_Standards = NULL)
}
\arguments{
\item{inputFileList}{A character vector of full file paths to the metabolite standard chromatof files to include in library.}

\item{RT1_Standards}{A character vector with the name of all first retention time standards to use to index metabolites. Defaults to NULL.}

\item{RT2_Standards}{A character vector with the name of all second retention time standards to use to index metabolites. Defaults to NULL.}
}
\value{
Returns a list with a retention standard indexed metabolite library that can be used in the standard library argument of the ConsensusAlign function
}
\description{
This function takes input chromatof files from metabolite standards and parses them into a dataframe of retention time indexed standards that can be used as an input for ConsensusAlign function
}
\examples{
MakeReference(c(system.file("extdata", "Alanine_150226_1.txt", package="R2DGC"),
    system.file("extdata", "Serine_022715_1.txt", package="R2DGC")))
}
