% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6causal_functions.R
\name{generate_condprob}
\alias{generate_condprob}
\title{Define structural function by a conditional probability table}
\usage{
generate_condprob(ycondx, x, Umerge_expr = NULL)
}
\arguments{
\item{ycondx}{A data table or a data frame with the following structure
\itemize{
\item 1st column: variable to be generated, "Y"
\item middle columns: the parents of the the 1st column variable, "X"
\item last column:  the probability the case specified be the other columns, "P(Y|do(X))"
}}

\item{x}{A data table or a data frame that contains data on the variables in the
middle columns of \code{ycondx}, "X" and one or more columns giving data on U-variables.}

\item{Umerge_expr}{A character string specifying how the U-variables will
be combined when the value "Y" is generated, e.g. "u" or "(u1+u2)/2". The result of the
expression should be a random number in the interval [0,1].}
}
\value{
A data table containing the generated  variable, "Y"
}
\description{
Define structural function by a conditional probability table
}
\examples{
ycondx <- data.table::data.table(y =rep(c(0,1), each = 3), x=rep(1:3, 2),
                     prob = c(0.2,0.6,0.1,0.8,0.4,0.9))
x <- data.table::data.table(x = sample(1:3, 20, replace = TRUE),
                       uy = stats::runif(20), uy2 = stats::runif(20))
generate_condprob(ycondx, x, Umerge_expr = "(uy+uy2)/2")
}
