% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_rafs_all_reps_from_popcnts}
\alias{get_rafs_all_reps_from_popcnts}
\title{Get all representatives from their popcnts}
\usage{
get_rafs_all_reps_from_popcnts(reps_popcnts, n_clusters)
}
\arguments{
\item{reps_popcnts}{representatives' popcnts for the chosen variant as obtained from \code{\link{get_rafs_reps_popcnts}}}

\item{n_clusters}{the desired number of clusters}
}
\value{
A vector of all representatives.
}
\description{
This helper function works on results of \code{\link{get_rafs_reps_popcnts}}
to obtain all representatives at the chosen number of clusters.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
rafs_results <- run_rafs(madelon$data, madelon$decision, 2, c(12345))
rafs_reps_popcnts <- get_rafs_reps_popcnts(rafs_results, 5)
get_rafs_all_reps_from_popcnts(rafs_reps_popcnts$stig_single, 5)
}
