% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PT.Khmaladze.fit.R
\name{PT.Khmaladze.fit}
\alias{PT.Khmaladze.fit}
\title{Non-Parametric Hypothesis Testing with a Nuisance Parameter: A Permutation Test}
\usage{
PT.Khmaladze.fit(y1, y0, alpha = 0.05, n.perm = 999)
}
\arguments{
\item{y1}{Numeric. A vector containing the response variable of the treatment group.}

\item{y0}{Numeric. A vector containing the response variable of the control group.}

\item{alpha}{Numeric. Nominal level for the test. The default is 0.05.}

\item{n.perm}{Numeric. Number of permutations needed for the stochastic approximation of the p-values. The default is n.perm=999.}
}
\value{
An object of class "PT.Khmaladze.fit" is a list containing at least the following components:

 \item{n_populations}{Number of grups.}
 \item{N}{Sample Size.}
 \item{T.obs}{Observed test statistic.}
 \item{shift}{The estimated nuisance parameter (average treatment effect).}
 \item{cv}{Critical Value. This value is used in the general construction of a randomization test.}
 \item{pvalue}{P-value.}
 \item{T.perm}{Vector. Test statistic recalculated for all permutations used in the stochastic approximation.}
 \item{n_perm}{Number of permutations.}
 \item{sample_sizes}{Groups size.}
}
\description{
A permutation test of the two-sample goodness-of-fit hypothesis in the presence of an estimated niusance parameter. The permutation test considered here is based on the Khmaladze transformation of the empirical process (Khmaladze (1981)), and adapted by Chung and Olivares-Gonzalez (2018).
}
\examples{
\dontrun{
Y0 <- rnorm(100, 1, 1)
# Treatment Group with constant shift equals to 1
Y1 <- Y0 + 1
Tx = sample(100) <= 0.5*(100)
# Observed Outcome 
Y = ifelse( Tx, Y1, Y0 )
dta <- data.frame(Y = Y, Z = as.numeric(Tx))
pt.GoF<-PT.Khmaladze.fit(dta$Y[dta$Z==1],data$Y[dta$Z==0],n.perm = 49)
summary(pt.GoF)
}
}
\references{
Khmaladze, E. (1981). Martingale Approach in the Theory of Goodness-of-fit Tests. Theory of Probability and its Application, 26: 240–257.
Chung, Eunyi and Mauricio Olivares (2018). Non-Parametric Hypothesis Testing with a Nuisance Parameter: A Permutation Test Approach. Working Paper.
}
\author{
Maurcio Olivares-Gonzalez

Ignacio Sarmiento Barbieri
}
\keyword{Khmaladze}
\keyword{Transformation}
\keyword{goodness-of-fit}
\keyword{permutation}
\keyword{test}
