% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbGetQuery}
\alias{dbGetQuery}
\alias{dbGetQuery,AthenaConnection,character-method}
\title{Send query, retrieve results and then clear result set}
\usage{
\S4method{dbGetQuery}{AthenaConnection,character}(conn, statement = NULL,
  ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbGetQuery()} returns a dataframe.
}
\description{
Send query, retrieve results and then clear result set
}
\examples{
\donttest{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())

# Sending Queries to Athena
dbGetQuery(con, "show databases")

# Disconnect conenction
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbGetQuery}}
}
