% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbGetPartition}
\alias{dbGetPartition}
\alias{dbGetPartition,AthenaConnection-method}
\title{Athena table partitions}
\usage{
dbGetPartition(conn, name, ..., .format = FALSE)

\S4method{dbGetPartition}{AthenaConnection}(conn, name, ..., .format = FALSE)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{...}{Other parameters passed on to methods.}

\item{.format}{re-formats AWS Athena partitions format. So that each column represents a partition
from the AWS Athena table. Default set to \code{FALSE} to prevent breaking previous package behaviour.}
}
\value{
data.frame that returns all partitions in table, if no partitions in Athena table then
        function will return error from Athena.
}
\description{
This method returns all partitions from Athena table.
}
\examples{
\dontrun{
# Note:
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name
con <- dbConnect(RAthena::athena())

# write iris table to Athena
dbWriteTable(con, "iris",
  iris,
  partition = c("timestamp" = format(Sys.Date(), "\%Y\%m\%d")),
  s3.location = "s3://path/to/store/athena/table/"
)

# return table partitions
RAthena::dbGetPartition(con, "iris")

# disconnect from Athena
dbDisconnect(con)
}
}
