% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{fetch_atom_chemical_shifts}
\alias{fetch_atom_chemical_shifts}
\title{Imports all chemical shifts of a given atom from BMRB database}
\usage{
fetch_atom_chemical_shifts(atom = "*", db = "macromolecules")
}
\arguments{
\item{atom}{atom name in NMR-STAR atom nomenclature ; Example: CA,CB2; default * (all atoms)}

\item{db}{macromolecules, metabolomics (optional, by default will fetch from macromolecules database)}
}
\value{
R data frame that contains full chemical shift list for a given atom
}
\description{
Downloads the full chemical shift data from BMRB macromolecules/metabolomics database for a given atom
}
\examples{
#df<-fetch_atom_chemical_shifts('CG2','macromolecules')
# Downloads CB2 chemical shifts from macromolecules database at BMRB
#df<-fetch_atom_chemical_shifts('C1','metabolomics')
# Downloads C1 chemical shifts from metabolomics database at BMRB
}
\seealso{
\code{\link{fetch_entry_chemical_shifts}},\code{\link{fetch_res_chemical_shifts}},\code{\link{filter_residue}} and \code{\link{chem_shift_corr}} and \code{\link{atom_chem_shift_corr}}
}
