% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SocketClass.R
\name{SocketClass}
\alias{SocketClass}
\title{SocketClass}
\description{
Al methods that are used by BasexClient and QueryClass
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SocketClass$new()}}
\item \href{#method-finalize}{\code{SocketClass$finalize()}}
\item \href{#method-bool_test_sock}{\code{SocketClass$bool_test_sock()}}
\item \href{#method-void_send}{\code{SocketClass$void_send()}}
\item \href{#method-str_receive}{\code{SocketClass$str_receive()}}
\item \href{#method-get_socket}{\code{SocketClass$get_socket()}}
\item \href{#method-clone}{\code{SocketClass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Initialize a new socket
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SocketClass$new(host, port = 1984L, username, password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host, port, username, password}}{Host-information and credentials}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\subsection{Method \code{finalize()}}{
When releasing the session-object, close the socketConnection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SocketClass$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bool_test_sock"></a>}}
\subsection{Method \code{bool_test_sock()}}{
Return a boolean that indicates the result from the last action on the socket
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SocketClass$bool_test_sock(socket)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{socket}}{Socket-ID}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-void_send"></a>}}
\subsection{Method \code{void_send()}}{
Send input to the socket
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SocketClass$void_send(input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Input}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Input is either a string or data that is read from a stream
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-str_receive"></a>}}
\subsection{Method \code{str_receive()}}{
Read a string from a stream
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SocketClass$str_receive(input, output, bin = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input, output}}{Input- and output-stream}

\item{\code{bin}}{Boolean; TRUE when str_receive has to retrieve binary data}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method is not intented to be called direct
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_socket"></a>}}
\subsection{Method \code{get_socket()}}{
Get socket-ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SocketClass$get_socket()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SocketClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
