% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-volcano.R
\name{plotVolcanoPathway}
\alias{plotVolcanoPathway}
\title{Plot volcano plot from Pathway analysis results}
\usage{
plotVolcanoPathway(
  PAResult,
  xAxis = c("normalizedScore", "score"),
  yAxis = c("-log10(pFDR)", "-log10(p.value)"),
  pThreshold = 0.05,
  label = "name",
  IDsToLabel = NULL,
  topToLabel = 10,
  sideToLabel = c("both", "left", "right")
)
}
\arguments{
\item{PAResult}{A data frame with Pathway analysis results.
The columns are ID, name, description, p.value, pFDR, pathwaySize, nDE, score and normalizedScore.}

\item{xAxis}{The column to use for the x-axis.}

\item{yAxis}{The column to use for the y-axis.}

\item{pThreshold}{The p-value threshold to use for the horizontal line.}

\item{label}{The column to use for the labels. Default is "name".}

\item{IDsToLabel}{A vector of IDs to label.
When NULL, the top pathways are labeled. Default is NULL.}

\item{topToLabel}{The number of top pathways to label when IDsToLabels is NULL.}

\item{sideToLabel}{The side of the plot to label.}
}
\value{
A ggplot2 object.
}
\description{
Plot volcano plot from Pathway analysis results
}
\examples{
\donttest{
library(RCPA)
affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")
metaPAResult <- loadData("metaPAResult")

RCPA::plotVolcanoPathway(affyFgseaResult, sideToLabel = "left")
RCPA::plotVolcanoPathway(agilFgseaResult, sideToLabel = "left")
RCPA::plotVolcanoPathway(RNASeqFgseaResult, sideToLabel = "left")
RCPA::plotVolcanoPathway(metaPAResult, sideToLabel = "left")

}

}
