\name{regiboot}
\alias{regiboot}
\title{Bootstraps a regimix object.}
\description{Performs bootstrap sample and estimation for regimix objects. Useful for calculating measures of uncertainty in predictions from a regimix object, and also about the regimix parameter estimates. This function can be used in conjunction with vcov.regimix(qv) and predict.regimix(qv). In partciular, these bootstrap samples can be used to gauge variability in parameter estimates and hence the model itself.
}
\usage{
 regiboot( object, nboot=1000, type="BayesBoot", mc.cores=1, quiet=FALSE,
                                            orderSamps=FALSE, MLstart=TRUE)
}
\arguments{
\item{ object}{an object obtained from fitting a RCP mixture model (class "regimix"). Such as that generated from a call to regimix(qv). This object will need to be created with the argument titbits=TRUE as these pieces of data are needed in the re-fitting. Of course, you could try to just save parts of titbits but the memory-hungry data is all required.}
\item{ nboot}{a numeric scalar giving the number of bootstrap samples to obtain. More is better, but takes longer.}
\item{ type}{a character string giving the type of bootstrap to perform. Options are:"SimpleBoot" which gives sample resampling, and "BayesBoot" (default) which gives Bayesian Bootstrap sampling. The nomenclature, and the Bayesian Bootstrap, come from Rubin (1981).}
\item{ mc.cores}{an integer giving the number of cores to run the bootstrap samples on. The default is 1, that is no parallelisation. This parameter is redundant on Windows machines as the method of parallelisation, mclapply(), is not available there.}
\item{ quiet}{should the progress bar be printed to the output device?If quiet=FALSE (default) then the progress bar is printed.}
\item{ orderSamps}{should each bootstrap sample be re-ordered to that permutation of RCP ordering that best matches the initial model? Default FALSE implies no re-ordering.}
\item{ MLstart}{should each bootstrap estimation start at the original model's ML estimate? Default is TRUE for \code{yes} it should.}
}
\details{
This function can take a while to run -- it is a bootstrap function. nboot re-samples of the data are taken and then the parameters are estimated for each re-sample. The function allows for parallel calculations, via mclapply(qv), which reduces some of the computational burden. To use parallel computing, specify mc.cores>1. Note that this will not work on Windows computers, as mclapply(qv) will not work.

The Bayesian bootstrap method is operationally equivalent to the simple bootstrap, except that the weightings are non-integral. See Rubin (1981).

It might be tempting to reduce the tolerance for convergence of each estimation procedure. We recommend not doing this as it is likely to have the effect of artificially reducing estimates of uncertainty. This occurs as the resampled estimates are liekly to be closer to their starting values (the MLEs from the original data set).
}
\value{An object of class "regiboot", which is essentially a matrix with nboot rows and the number of columns equal to the number of parameters matrix. Each row gives a bootstrap estimate of the parameters.
}
\author{Scott D. Foster}
\references{
Foster, S.D., Lyons, M. and Hill, N. (in prep.) Ecological Groupings of Sample Sites in the presence of sampling artefacts.

Rubin, D.B. (1981) The Bayesian Bootstrap. The Annals of Statistics \emph{9}:130--134.
}
\keyword{misc}
