% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{target.binary.data}
\alias{target.binary.data}
\title{A dataset of simulated RCT data, where outcome is binary variable. The data is filtered after compared to source.binary.data}
\format{
A data frame with 3194 rows and 9 variables.
\describe{
\item{x1}{binary variable, x1 ~ rbinom(5000,1,0.7)}
\item{x2}{binary variable, x2 ~ rbinom(5000,1,0.9)}
\item{x3}{binary variable, x3 ~ rbinom(5000,1,0.2)}
\item{x4}{binary variable, x4 ~ rbinom(5000,1,0.3)}
\item{x5}{binary variable, x5 ~ rbinom(5000,1,0.2)}
\item{x6}{binary variable, x6 ~ rbinom(5000,1,0.3)}
\item{z}{binary variable. pp = x1*x2+x3*x4+5*x5+x6, p(z=1) = p = 1/1+exp^{-(pp-mean(pp))/sd(pp)*sqrt(3)/pi}, z ~ rbinom(5000,1,p)}
\item{y}{binary variable. pp = x1 + (6*x2+x6+2)*z, p(y=1) = p = 1/1+exp^{-(pp-mean(pp))/sd(pp)*sqrt(3)/pi}, y ~ rbinom(5000,1,p)}
\item{pt}{a continuous variable within 0 and 1, specifying the probability of p(z=1) given x1,x2,x3,x4,x5,x6}
}
}
\usage{
target.binary.data
}
\description{
A dataset of simulated RCT data, where outcome is binary variable. The data is filtered after compared to source.binary.data
}
\keyword{datasets}
