% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiPhasePlot}
\alias{MultiPhasePlot}
\title{ Plot of the marginal posterior densities of several phases}
\usage{
MultiPhasePlot(file, position, level = 0.95, dec = '.', sep=',', comment.char='#',
  title = "Phases marginal posterior densities", GridLength = 1024)
}
\arguments{
  \item{file}{name of the CSV file containing the output of the MCMC algorithm of all phases of interest}
  \item{position}{numeric vector containing the position of the phases of interest in the CSV file}
  \item{level}{probability corresponding to the level of confidence}
  \item{dec}{the character used in the file for decimal points for the use of read.csv()}
  \item{sep}{the field separator character for the use of read.csv()}
  \item{comment.char}{a character vector of length one containing a single character or an empty string for the use of read.csv()}
  \item{title}{title of the graph}
  \item{GridLength}{length of the grid used to estimate the density}
}
\description{
Draws a plot with the marginal posterior densities of the beginning and the end of all phases. No temporal order between phases is required.
}
\value{
Draws a plot with the marginal posterior densities of the beginning and the end of all phases and adds the time range of each phase.
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases)
  write.csv(Phases, "data.csv")
  MultiPhasePlot("data.csv", c(4,2),level = 0.95, title="Densities of phase 1 and phase 2")
}
\keyword{ phase time range }
\keyword{ marginal posterior density }
