% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds2dd_detailed.R
\name{var2fct}
\alias{var2fct}
\title{Convert vector to factor based on threshold of number of unique levels}
\usage{
var2fct(data, unique.n)
}
\arguments{
\item{data}{vector or data.frame column}

\item{unique.n}{threshold to convert class to factor}
}
\value{
vector
}
\description{
This is a wrapper of forcats::as_factor, which sorts numeric vectors before
factoring, but levels character vectors in order of appearance.
}
\examples{
sample(seq_len(4), 20, TRUE) |>
  var2fct(6) |>
  summary()
sample(letters, 20) |>
  var2fct(6) |>
  summary()
sample(letters[1:4], 20, TRUE) |> var2fct(6)
}
