% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_tibbles.R
\name{bind_tibbles}
\alias{bind_tibbles}
\title{Extract data tibbles from a REDCapTidieR supertibble and bind them to an
environment}
\usage{
bind_tibbles(supertbl, environment = global_env(), tbls = NULL)
}
\arguments{
\item{supertbl}{A supertibble generated by \code{read_redcap()}. Required.}

\item{environment}{The environment to bind the tibbles to. Default is
\code{rlang::global_env()}.}

\item{tbls}{A vector of the \code{redcap_form_name}s of the data tibbles to bind to
the environment. Default is \code{NULL} which binds all data tibbles.}
}
\value{
This function returns nothing as it's used solely for its side effect of
modifying an environment.
}
\description{
Take a supertibble generated with \code{read_redcap()}
and bind its data tibbles (i.e. the tibbles in the \code{redcap_data} column) to
an environment. The default is the global environment.
}
\examples{
# Create an empty environment
my_env <- new.env()

ls(my_env)

# Mock up a supertibble
supertbl <- tibble::tribble(
  ~redcap_form_name,    ~redcap_data,   ~structure,
  "super_hero_powers",  list(),         "repeating",
  "heroes_information", list(),         "nonrepeating"
)

bind_tibbles(supertbl, my_env)

ls(my_env)

}
