% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{apply_labs_haven}
\alias{apply_labs_haven}
\title{Apply haven value labels to a vector}
\usage{
apply_labs_haven(x, labels, ptype, ...)
}
\arguments{
\item{x}{a vector to label}

\item{labels}{a named vector of labels in the format \code{c(value = label)}}

\item{ptype}{vector to serve as prototype for label values}

\item{\dots}{unused, needed to ignore extra arguments that may be passed}
}
\value{
\code{haven_labelled} vector
}
\description{
Apply haven value labels to a vector
}
\details{
Assumes a check_installed() has been run for \code{labelled}. Since \code{haven} preserves the
underlying data values we need to make sure the data type of the value options in the metadata matches
the data type of the values in the actual data. This function accepts a prototype, usually a column
from db_data, and uses \code{force_cast()} to do a best-effort casting of the value options in the metadata
to the same data type as \code{ptype}. The fallback is to convert \code{x} and the value labels to character.
}
\keyword{internal}
