/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import javalain.ea.SolutionEA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Fct {
    protected double[][] front = null;
    protected int nbVariable;
    protected double[] lowerLimit;
    protected double[] upperLimit;
    protected int nbFctObjectif;
    protected String nomFct;
    protected int nbEvaluation;

    public double[] getLowerLimit() {
        return this.lowerLimit;
    }

    public double[] getUpperLimit() {
        return this.upperLimit;
    }

    public double getLowerLimit(int i) {
        return this.lowerLimit[i];
    }

    public double getUpperLimit(int i) {
        return this.upperLimit[i];
    }

    public int getNbVariable() {
        return this.nbVariable;
    }

    public int getNbFctObjectif() {
        return this.nbFctObjectif;
    }

    public void setLowerLimit(double[] x) {
        if (this.lowerLimit != null && this.lowerLimit.length == x.length) {
            System.arraycopy(x, 0, this.lowerLimit, 0, x.length);
        }
    }

    public void setUpperLimit(double[] x) {
        if (this.upperLimit != null && this.upperLimit.length == x.length) {
            System.arraycopy(x, 0, this.upperLimit, 0, x.length);
        }
    }

    public String getNomFct() {
        return this.nomFct;
    }

    public void razNbEvalution() {
        this.nbEvaluation = 0;
    }

    public int getNbEvaluation() {
        return this.nbEvaluation;
    }

    public double[] limite(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] < this.lowerLimit[i]) {
                x[i] = this.lowerLimit[i];
            }
            if (!(x[i] > this.upperLimit[i])) continue;
            x[i] = this.upperLimit[i];
        }
        return x;
    }

    protected void readParetoFront(String nom_fich) {
        try {
            InputStreamReader is = new InputStreamReader(this.getClass().getResourceAsStream("../../../ea/pf/" + nom_fich));
            BufferedReader buffer = new BufferedReader(is);
            String s = buffer.readLine();
            StringTokenizer st = new StringTokenizer(s);
            int nbSol = 0;
            int nbObj = st.countTokens();
            ArrayList<String> liste = new ArrayList<String>(1000);
            do {
                st = new StringTokenizer(s);
                while (st.hasMoreTokens()) {
                    liste.add(st.nextToken());
                }
                ++nbSol;
            } while ((s = buffer.readLine()) != null);
            buffer.close();
            is.close();
            this.front = new double[liste.size() / nbObj][nbObj];
            for (int i = 0; i < nbSol; ++i) {
                for (int j = 0; j < nbObj; ++j) {
                    this.front[i][j] = Double.parseDouble((String)liste.get(i * nbObj + j));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Fct, readParetoFront (String) : lecture du fichier '" + nom_fich + "' impossible.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fct other = (Fct)obj;
        return !(this.nomFct == null ? other.nomFct != null : !this.nomFct.equals(other.nomFct));
    }

    public abstract double[] compute(double[] var1);

    public abstract double[][] getFront();

    public abstract Comparator<SolutionEA> comparator();
}

