/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.simpleobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.ObjectiveComparator;
import javalain.math.fonction.Fct;

public final class Schwefel_1
extends Fct {
    public Schwefel_1() {
        this(10);
    }

    public Schwefel_1(int d) {
        this.nomFct = "Schwefel_1";
        this.nbVariable = d;
        this.nbFctObjectif = 1;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        for (int i = 0; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = -65.536;
            this.upperLimit[i] = 65.536;
        }
    }

    @Override
    public double[] compute(double[] x) {
        ++this.nbEvaluation;
        double[] fct = new double[this.nbFctObjectif];
        fct[0] = 0.0;
        for (int i = 0; i < this.nbVariable; ++i) {
            double somme = 0.0;
            for (int j = 0; j <= i; ++j) {
                somme += x[j];
            }
            fct[0] = fct[0] + somme * somme;
        }
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.front = new double[1][this.nbVariable];
            for (int i = 0; i < this.nbVariable; ++i) {
                this.front[0][i] = 0.0;
            }
        }
        return this.front;
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new ObjectiveComparator(0);
    }
}

