/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.generalstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import java.io.Serializable;

public abstract class SSSPInstance
implements Serializable {
    private double[][] matrix;
    private double[] optDist = null;
    protected int dimension;
    protected RandomElement re;
    private double[] distances;
    private boolean[] visited;

    public SSSPInstance(int dimension, RandomElement re) {
        this.dimension = dimension;
        this.re = re;
    }

    public void nextInstance() {
        this.matrix = this.getNextDistanceMatrix();
        this.optDist = null;
    }

    public double[] getMultiFitness(int[] gt) throws UnsupportedEnvironmentException {
        if (gt.length != this.dimension - 1) {
            throw new UnsupportedEnvironmentException();
        }
        this.distances = new double[this.dimension - 1];
        this.visited = new boolean[this.dimension - 1];
        int i = 0;
        while (i < this.dimension - 1) {
            if (this.distances[i] == 0.0) {
                this.distances[i] = this.matrix[gt[i]][i] + this.length(gt, gt[i]);
            }
            ++i;
        }
        return this.distances;
    }

    private double length(int[] gt, int i) {
        if (i == this.dimension - 1) {
            return 0.0;
        }
        if (this.distances[i] > 0.0) {
            return this.distances[i];
        }
        if (this.visited[i]) {
            return Double.POSITIVE_INFINITY;
        }
        this.visited[i] = true;
        this.distances[i] = this.matrix[gt[i]][i] + this.length(gt, gt[i]);
        return this.distances[i];
    }

    public double[] getOptimum() {
        if (this.optDist != null) {
            return this.optDist;
        }
        boolean[] choosen = new boolean[this.dimension - 1];
        this.optDist = new double[this.dimension - 1];
        int i = 0;
        while (i < this.dimension - 1) {
            this.optDist[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        double min = Double.POSITIVE_INFINITY;
        int minNode = -1;
        int i2 = 0;
        while (i2 < this.dimension - 1) {
            this.optDist[i2] = this.matrix[this.dimension - 1][i2];
            if (this.optDist[i2] < min) {
                min = this.optDist[i2];
                minNode = i2;
            }
            ++i2;
        }
        if (minNode == -1) {
            return this.optDist;
        }
        int numChoosen = 0;
        while (numChoosen < this.dimension) {
            choosen[minNode] = true;
            int newNode = minNode;
            min = Double.POSITIVE_INFINITY;
            minNode = -1;
            int i3 = 0;
            while (i3 < this.dimension - 1) {
                if (!choosen[i3]) {
                    if (this.matrix[newNode][i3] + this.optDist[newNode] < this.optDist[i3]) {
                        this.optDist[i3] = this.matrix[newNode][i3] + this.optDist[newNode];
                    }
                    if (this.optDist[i3] < min) {
                        min = this.optDist[i3];
                        minNode = i3;
                    }
                }
                ++i3;
            }
            if (minNode == -1) {
                return this.optDist;
            }
            ++numChoosen;
        }
        return this.optDist;
    }

    public void setRandomElement(RandomElement re) {
        this.re = re;
    }

    protected abstract double[][] getNextDistanceMatrix();

    protected abstract double getLargestMatrixEntry();
}

