/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.GenerationEvent;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.stoppingcriterion.AbstractGenerationStoppingCriterion;
import freak.module.fitness.generalstring.IsingModelCliques;
import freak.module.searchspace.GeneralStringGenotype;

public class IsingModelCliquesFinished
extends AbstractGenerationStoppingCriterion {
    private boolean allCliquesIdenticallyColored = true;

    public IsingModelCliquesFinished(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getRealFitnessFunction() instanceof IsingModelCliques)) {
            throw new UnsupportedEnvironmentException();
        }
    }

    protected void checkCriterion(GenerationEvent evt) {
        IndividualList p = this.getSchedule().getPopulationManager().getPopulation();
        Individual ind = p.getIndividualWithRank(1);
        IsingModelCliques ising = (IsingModelCliques)this.getSchedule().getRealFitnessFunction();
        IsingModelCliques.Clique[] cliques = ising.getCliques();
        int[] gen = ((GeneralStringGenotype)ind.getGenotype()).getIntArray();
        this.allCliquesIdenticallyColored = true;
        int i = 0;
        while (i < cliques.length) {
            int color = gen[cliques[i].getStart()];
            if (color != gen[0]) {
                this.allCliquesIdenticallyColored = false;
            }
            int j = cliques[i].getStart();
            while (j < cliques[i].getStart() + cliques[i].getSize()) {
                if (gen[j] != color) {
                    return;
                }
                ++j;
            }
            ++i;
        }
        this.stopRun();
    }

    public String getName() {
        return "Cliques Finished";
    }

    public String getDescription() {
        return "Stopps the run if in each clique all nodes are colored identically.";
    }

    public boolean getAllCliquesColoredIdentically() {
        return this.allCliquesIdenticallyColored;
    }
}

