/*
 * Decompiled with CFR 0.152.
 */
package freak.core.util;

import javax.swing.SwingUtilities;

public class SwingUtilitiesExtra {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninterruptibleInvokeAndWait(Runnable r) {
        FlaggedRunnable task = new FlaggedRunnable(r);
        SwingUtilities.invokeLater(task);
        boolean interrupted = false;
        while (!task.isDone()) {
            try {
                FlaggedRunnable flaggedRunnable = task;
                synchronized (flaggedRunnable) {
                    task.wait();
                }
            }
            catch (InterruptedException exc) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static class FlaggedRunnable
    implements Runnable {
        private Runnable target;
        private boolean done;

        public FlaggedRunnable(Runnable target) {
            this.target = target;
        }

        public synchronized void run() {
            this.target.run();
            this.done = true;
            this.notify();
        }

        public synchronized boolean isDone() {
            return this.done;
        }
    }
}

