/*
 * Decompiled with CFR 0.152.
 */
package freak.module.mapper.graphedgeselection;

import freak.core.control.Schedule;
import freak.core.mapper.AbstractMapper;
import freak.core.population.Genotype;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.GraphEdgeSelection;
import freak.module.searchspace.GraphEdgeSelectionGenotype;

public class BitStringMapper
extends AbstractMapper {
    private BitString genotypeSearchSpace;

    public BitStringMapper(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        GraphEdgeSelection space = (GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace();
        try {
            int dimension = space.getDimension();
            this.genotypeSearchSpace = new BitString(this.schedule, dimension);
        }
        catch (IllegalStateException exc) {
            this.genotypeSearchSpace = new BitString(this.schedule);
        }
    }

    public Genotype genotypeToPhenotype(Genotype genotype) {
        GraphEdgeSelectionGenotype gen = new GraphEdgeSelectionGenotype(((GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace()).getGraph());
        BitStringGenotype bsg = (BitStringGenotype)genotype;
        gen.setEdgeSelection(bsg.getBooleanArray());
        return gen;
    }

    public Genotype phenotypeToGenotype(Genotype phenotype) throws UnsupportedOperationException {
        if (phenotype == null) {
            return null;
        }
        GraphEdgeSelectionGenotype graphGenotype = (GraphEdgeSelectionGenotype)phenotype;
        BitStringGenotype bsg = new BitStringGenotype(graphGenotype.getEdgeSelection());
        return bsg;
    }

    public String getName() {
        return "Edge Selection to Bit String";
    }

    public String getDescription() {
        return "Encodes Edge Selections as Bit Strings";
    }

    public SearchSpace getGenotypeSearchSpace() {
        return this.genotypeSearchSpace;
    }
}

