/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.util;

import freak.module.fitness.pointset.util.InvalidLengthException;
import freak.module.fitness.pointset.util.InvalidNthElementException;
import freak.module.fitness.pointset.util.M_HALFS;
import freak.module.fitness.pointset.util.QuickSelect;
import freak.module.fitness.pointset.util.RandomGrabBag;
import freak.module.fitness.pointset.util.WMedianElement;
import freak.module.fitness.pointset.util.WeightedMedianComputation;
import java.io.Serializable;
import java.util.Arrays;

public class QuickSelectDeltaMatrix
implements Serializable {
    private final double EQUALITY_THRESHOLD = 2.5E-323;
    private boolean randomised = false;
    public int DEBUG_LEVEL = -1;
    QuickSelect<Double> myQS = new QuickSelect();

    public double findNthGreatestElementOfXplusYHalf(double[] x, double[] y, long nthElement, M_HALFS half) throws InvalidLengthException {
        int[] lb = new int[x.length];
        int[] rb = new int[x.length];
        switch (half) {
            case LEFT_UPPER: {
                int i = 0;
                while (i < rb.length) {
                    rb[i] = rb.length - i;
                    ++i;
                }
                break;
            }
            case RIGHT_UPPER: {
                int i = 0;
                while (i < rb.length) {
                    rb[i] = rb.length;
                    lb[i] = i;
                    ++i;
                }
                break;
            }
            case LEFT_LOWER: {
                int i = 0;
                while (i < rb.length) {
                    rb[i] = i + 1;
                    ++i;
                }
                break;
            }
            case RIGHT_LOWER: {
                int i = 0;
                while (i < rb.length) {
                    rb[i] = rb.length;
                    lb[i] = rb.length - i - 1;
                    ++i;
                }
                break;
            }
        }
        return this.findNthGreatestElementOfXplusY(x, y, nthElement, lb, rb);
    }

    public double findNthGreatestElementOfXplusY(double[] x, double[] y, long nthElement) throws InvalidLengthException {
        int[] lb = new int[x.length];
        int[] rb = new int[x.length];
        int i = 0;
        while (i < rb.length) {
            rb[i] = rb.length;
            ++i;
        }
        return this.findNthGreatestElementOfXplusY(x, y, nthElement, lb, rb);
    }

    public double findNthGreatestElementOfXplusY(double[] x, double[] y, long nthElement, int[] lb, int[] rb) throws InvalidLengthException {
        int n = x.length;
        if (x.length != y.length) {
            throw new InvalidLengthException("Die Laenge der beiden Arrays muss uebereinstimmen");
        }
        Arrays.sort(x);
        Arrays.sort(y);
        int i = 0;
        while (i < n / 2) {
            double temp = x[i];
            x[i] = x[n - i - 1];
            x[n - i - 1] = temp;
            temp = y[i];
            y[i] = y[n - i - 1];
            y[n - i - 1] = temp;
            ++i;
        }
        WMedianElement[] wmel = new WMedianElement[n];
        int i2 = 0;
        while (i2 < wmel.length) {
            wmel[i2] = new WMedianElement();
            ++i2;
        }
        WeightedMedianComputation medComp = new WeightedMedianComputation();
        long L = 0L;
        long R = n * n;
        while (R - L > (long)n) {
            double a_mMinusXi;
            int i3;
            double weightedmed = 0.0;
            if (this.randomised) {
                RandomGrabBag bag = new RandomGrabBag(0, n);
                while (lb[i3 = bag.grab()] + 1 > rb[i3]) {
                }
                try {
                    weightedmed = medComp.computeMedianForSortedArrays(x, y, i3, lb[i3], rb[i3] - 1);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            } else {
                i3 = 0;
                while (i3 < n) {
                    if (lb[i3] < rb[i3]) {
                        wmel[i3].setValue(medComp.computeMedianForSortedArrays(x, y, i3, lb[i3], rb[i3]));
                        wmel[i3].setWeight(rb[i3] - lb[i3]);
                    } else {
                        wmel[i3].setValue(0.0);
                        wmel[i3].setWeight(0);
                    }
                    ++i3;
                }
                weightedmed = medComp.weightedMedian(wmel);
            }
            int[] P_i = new int[n];
            int[] Q_i = new int[n];
            int j = 0;
            int i4 = n;
            while (i4 > 0) {
                a_mMinusXi = weightedmed - x[i4 - 1];
                while (j < n && y[j] > a_mMinusXi + 2.5E-323) {
                    ++j;
                }
                P_i[i4 - 1] = j;
                --i4;
            }
            j = n;
            i4 = 0;
            while (i4 < n) {
                a_mMinusXi = weightedmed - x[i4];
                while (j > 0 && y[j - 1] < a_mMinusXi - 2.5E-323) {
                    --j;
                }
                Q_i[i4] = j;
                ++i4;
            }
            long sumPi = 0L;
            long sumQi = 0L;
            int i5 = 0;
            while (i5 < n) {
                sumPi += (long)P_i[i5];
                sumQi += (long)Q_i[i5];
                ++i5;
            }
            if (nthElement < sumPi) {
                i5 = 0;
                while (i5 < n) {
                    rb[i5] = P_i[i5];
                    ++i5;
                }
            } else if (nthElement >= sumQi) {
                i5 = 0;
                while (i5 < n) {
                    lb[i5] = Q_i[i5];
                    ++i5;
                }
            } else {
                return weightedmed;
            }
            long sumLb_i = 0L;
            long sumRb_i = 0L;
            int i6 = 0;
            while (i6 < n) {
                sumLb_i += (long)lb[i6];
                sumRb_i += (long)rb[i6];
                ++i6;
            }
            L = sumLb_i;
            R = sumRb_i;
            if (this.DEBUG_LEVEL != 0) continue;
            i6 = 0;
            while (i6 < x.length) {
                System.out.println("");
                int k = 0;
                while (k < x.length) {
                    if (k == lb[i6]) {
                        System.out.print("|");
                    }
                    if (k == rb[i6]) {
                        System.out.print("|");
                    }
                    System.out.print(String.valueOf(x[i6] + y[k]) + ", ");
                    ++k;
                }
                ++i6;
            }
            System.out.println();
            System.out.println("------------");
        }
        n = (int)(R - L);
        Comparable[] values = new Double[n];
        int l = 0;
        int i7 = 0;
        while (i7 < x.length) {
            int j = lb[i7];
            while (j < rb[i7]) {
                values[l] = Double.valueOf(x[i7] + y[j]);
                ++l;
                ++j;
            }
            ++i7;
        }
        try {
            return (Double)this.myQS.quickSelectNthSmallestElement(values, (int)((long)n - (nthElement - L)) - 1);
        }
        catch (InvalidNthElementException e) {
            e.printStackTrace();
            throw new Error("debug");
        }
    }
}

