/*
 * This file is part of RFrEAK. For licensing and copyright information
 * please see the file COPYING in the root directory of this
 * distribution or contact <robin.nunkesser@udo.edu>.
 * 
 * This file is a modification of the original file distributed with
 * FrEAK (http://sourceforge.net/projects/freak427/).
 * Last modification: 06/28/2007
 */

package freak.gui.scheduleeditor;

import freak.core.mapper.Mapper;
import freak.core.modulesupport.*;
import freak.gui.*;

/**
 * @author  Oliver, Michael
 */
public class PanelMapper extends ScheduleEditorPanel {

	/**
	 * @uml.property  name="mapper"
	 * @uml.associationEnd  multiplicity="(0 -1)"
	 */
	private Module[] mapper;

	private boolean scheduleStarted = false;
	
	/** remembers the last selected mapper */
	private int lastSelectedIndex;

	/** Creates new JPanel */
	public PanelMapper(ScheduleEditor scheduleEditor) {
		super(scheduleEditor);
		initComponents();
	}

	public static String getDescription() {
		return "Select Genotype-Mapper";
	}

	protected void initForStartedSchedule() {
		cbUseMapper.setEnabled(false);
		buConfigMapper.setVisible(false);
		listMapper.setEnabled(false);
		scheduleStarted = true;
	}

	public String getHelpURL() {
		return "node4.html#SECTION00443000000000000000";
	}

	public boolean mayAdvance() {
		return true;
	}

	public void enter() {
		super.enter();
		boolean useMapper = schedule.getMapper() != null;
		mapper = moduleCollector.getMapper(schedule.getPhenotypeSearchSpace());
		((ModuleList)listMapper).setModules(mapper, schedule.getMapper());
		if (useMapper) lastSelectedIndex = listMapper.getSelectedIndex();
		cbUseMapper.setSelected(useMapper);
		updateStatus();
	}
	
	/**
	 * Updates the display and enabled/disabled status of the controls
	 */
	private void updateStatus() {
		boolean useMapper = cbUseMapper.isSelected();
		listMapper.setEnabled(useMapper && (!scheduleStarted));
		if (useMapper) {
			listMapper.setSelectedIndex(lastSelectedIndex);
		} else {
			lastSelectedIndex = listMapper.getSelectedIndex();
			listMapper.getSelectionModel().clearSelection();
		}
		buConfigMapper.setEnabled(useMapper && schedule.getMapper() instanceof Configurable);
		taDescrMapper.setEnabled(useMapper);
	}

	private void parse() {
		Module m = schedule.getMapper();
		Util.displayText(taDescrMapper, (m != null) ? m.getDescription() : "<no mapper selected>");
		if (m instanceof Configurable)
			Util.displayText(tfOptionsMapper, ((Configurable)m).getConfiguration().getDescription());
		else
			Util.displayText(tfOptionsMapper, "<not configurable>");
		buConfigMapper.setEnabled(m instanceof Configurable);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() {//GEN-BEGIN:initComponents
		java.awt.GridBagConstraints gridBagConstraints;
		
		panelMapper = new javax.swing.JPanel();
		buConfigMapper = new javax.swing.JButton();
		jLabel1 = new javax.swing.JLabel();
		jScrollPane5 = new javax.swing.JScrollPane();
		listMapper = new ModuleList();
		jLabel2 = new javax.swing.JLabel();
		jScrollPane6 = new javax.swing.JScrollPane();
		taDescrMapper = new javax.swing.JTextArea();
		jLabel18 = new javax.swing.JLabel();
		tfOptionsMapper = new javax.swing.JTextField();
		cbUseMapper = new javax.swing.JCheckBox();
		
		setLayout(new java.awt.GridBagLayout());
		
		setBorder(new javax.swing.border.TitledBorder("Select Mapper"));
		panelMapper.setLayout(new java.awt.GridBagLayout());
		
		buConfigMapper.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
		buConfigMapper.setMnemonic('o');
		buConfigMapper.setText("Configure...");
		buConfigMapper.setEnabled(false);
		buConfigMapper.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				buConfigMapperActionPerformed(evt);
			}
		});
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		panelMapper.add(buConfigMapper, gridBagConstraints);
		
		jLabel1.setText("Options:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		panelMapper.add(jLabel1, gridBagConstraints);
		
		jScrollPane5.setMinimumSize(new java.awt.Dimension(220, 0));
		jScrollPane5.setPreferredSize(new java.awt.Dimension(220, 0));
		listMapper.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
		listMapper.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				listMapperValueChanged(evt);
			}
		});
		
		jScrollPane5.setViewportView(listMapper);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridheight = 3;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weighty = 0.1;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		panelMapper.add(jScrollPane5, gridBagConstraints);
		
		jLabel2.setText("Mapper:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		panelMapper.add(jLabel2, gridBagConstraints);
		
		taDescrMapper.setEditable(false);
		taDescrMapper.setLineWrap(true);
		taDescrMapper.setText("<no mapper selected>");
		taDescrMapper.setWrapStyleWord(true);
		jScrollPane6.setViewportView(taDescrMapper);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.weighty = 0.1;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		panelMapper.add(jScrollPane6, gridBagConstraints);
		
		jLabel18.setText("Description:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		panelMapper.add(jLabel18, gridBagConstraints);
		
		tfOptionsMapper.setEditable(false);
		tfOptionsMapper.setText("<no mapper selected>");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
		panelMapper.add(tfOptionsMapper, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.weighty = 0.2;
		add(panelMapper, gridBagConstraints);
		
		cbUseMapper.setText("Use Phenotype - Genotype Mapper");
		cbUseMapper.setToolTipText("Check this to enable the selection of a mapper module that maps phenotype individuals to genotype individuals and vice versa.");
		cbUseMapper.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				cbUseMapperActionPerformed(evt);
			}
		});
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.weighty = 1.0E-4;
		add(cbUseMapper, gridBagConstraints);
		
	}//GEN-END:initComponents

	private void cbUseMapperActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbUseMapperActionPerformed
		updateStatus();
		
		if (!cbUseMapper.isSelected() && schedule.getMapper() != null) {
			// remove mapper from schedule
			schedule.getEventController().removeModule(schedule.getMapper());
			schedule.setMapper(null);
			
			scheduleDependencyChecker.processNewMapper();
		} 
	}//GEN-LAST:event_cbUseMapperActionPerformed

	private void buConfigMapperActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buConfigMapperActionPerformed
		String s = Util.configureModule(scheduleEditor, schedule.getMapper(), schedule);
		if (s != null)
			Util.displayText(tfOptionsMapper, s);
		scheduleDependencyChecker.processNewModuleConfiguration(schedule.getMapper());
		scheduleEditor.updateComponents();
	}//GEN-LAST:event_buConfigMapperActionPerformed

	private void listMapperValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_listMapperValueChanged
		if (evt.getValueIsAdjusting())
			return;
		if (!listMapper.isValid() || !listMapper.isEnabled()) return;

		Mapper oldObj = schedule.getMapper();
		Mapper newObj = (Mapper)listMapper.getSelectedValue();
		if (newObj != oldObj) {
			if (oldObj != null) {
				eventController.replaceGlobalEventSource(oldObj, newObj);
				eventController.removeModule(oldObj);
			}
			schedule.setMapper(newObj);
			scheduleDependencyChecker.processNewMapper();
			if (newObj != null) newObj.createEvents();
			scheduleEditor.updateComponents();
		}
		parse();
	}//GEN-LAST:event_listMapperValueChanged

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton buConfigMapper;
	private javax.swing.JCheckBox cbUseMapper;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel18;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JScrollPane jScrollPane5;
	private javax.swing.JScrollPane jScrollPane6;
	private javax.swing.JList listMapper;
	private javax.swing.JPanel panelMapper;
	private javax.swing.JTextArea taDescrMapper;
	private javax.swing.JTextField tfOptionsMapper;
	// End of variables declaration//GEN-END:variables

}
