/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.searchspace.HasDimension;
import freak.core.stoppingcriterion.AbstractStoppingCriterion;

public class MultiplicativeGenerationCount
extends AbstractStoppingCriterion
implements Configurable,
GenerationEventListener {
    private int basecount = 1000;
    private double multiplier;

    public MultiplicativeGenerationCount(Schedule schedule) {
        super(schedule);
        if (schedule.getGenotypeSearchSpace() instanceof HasDimension) {
            int dim = ((HasDimension)((Object)schedule.getGenotypeSearchSpace())).getDimension();
            this.basecount = (int)Math.round((double)dim * (Math.log(dim) / Math.log(2.0)));
        }
        this.multiplier = 2.0;
    }

    public String getName() {
        return "Multiplicative Generation Count";
    }

    public String getDescription() {
        return "Stops a run after \"basecount * multiplier^(runnumber-1)\" number of generations.";
    }

    public void setPropertyBaseCount(Integer count) {
        if (count > 0) {
            this.basecount = count;
        }
    }

    public Integer getPropertyBaseCount() {
        return new Integer(this.basecount);
    }

    public String getShortDescriptionForBaseCount() {
        return "Base count";
    }

    public String getLongDescriptionForBaseCount() {
        return "The base number of generations after a run will be stopped. The exact number of generations after the first run will be stopped.";
    }

    public void setPropertyMultiplier(Double count) {
        if (count > 1.0) {
            this.multiplier = count;
        }
    }

    public Double getPropertyMultiplier() {
        return new Double(this.multiplier);
    }

    public String getShortDescriptionForMultiplier() {
        return "Multiplier";
    }

    public String getLongDescriptionForMultiplier() {
        return "Number of generations = (Number of generations of the run before) * multiplier";
    }

    public void generation(GenerationEvent evt) {
        if ((double)evt.getNumber() >= (double)this.basecount * Math.pow(this.multiplier, this.getSchedule().getCurrentRun() - 1)) {
            this.stopRun();
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, GenerationEvent.class, this.schedule);
    }
}

