/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo;

import edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo.ControlToolBar;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo.Controller;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo.Model;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

final class Application
extends JFrame {
    private Model model;
    private Controller controller;
    private ControlToolBar controlToolBar;
    private View view;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu zoomMenu = new JMenu("Zoom");
    private Action zoomAction;
    private Action unzoomAction;
    private Action moveAction;
    private JMenu resolutionMenu = new JMenu("Resolution");
    private Action res5Action;
    private Action res6Action;
    private Action res7Action;
    private Action res8Action;
    private Action res9Action;
    private JMenu colorBitsMenu = new JMenu("Color bits");
    private Action bits1Action;
    private Action bits2Action;
    private Action bits3Action;
    private Action bits4Action;
    private JMenu janetMenu = new JMenu("Janet");
    private JPanel viewPanel = new JPanel(new BorderLayout());

    Application(int n) {
        super("JICOS: Branch And Bound: TSP Demonstration");
        this.model = new Model(n);
        this.controller = new Controller(this.model);
        this.controlToolBar = new ControlToolBar(this.model);
        this.view = new View(this.model, this.controller);
        this.menuBar.add(this.janetMenu);
        this.setJMenuBar(this.menuBar);
        this.viewPanel.add((Component)new JScrollPane(this.view), "Center");
        Container container = this.getContentPane();
        container.add((Component)this.controlToolBar, "North");
        container.add((Component)this.viewPanel, "Center");
        container.add((Component)this.controller, "South");
    }

    private void initBits1() {
        this.bits1Action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.model.setColorBits(1);
            }
        };
        this.bits1Action.putValue("Name", "3");
        this.bits1Action.putValue("ShortDescription", "3-bit color: iteration limit: 8");
        this.bits1Action.putValue("MnemonicKey", new Integer(51));
        this.colorBitsMenu.add(this.bits1Action);
    }

    private void initBits2() {
        this.bits2Action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.model.setColorBits(2);
            }
        };
        this.bits2Action.putValue("Name", "6");
        this.bits2Action.putValue("ShortDescription", "6-bit color: iteration limit: 64");
        this.bits2Action.putValue("MnemonicKey", new Integer(54));
        this.colorBitsMenu.add(this.bits2Action);
    }

    private void initMove() {
        this.moveAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.model.setOperation(0);
            }
        };
        this.moveAction.putValue("Name", "Move");
        this.moveAction.putValue("ShortDescription", "Move");
        this.moveAction.putValue("MnemonicKey", new Integer(77));
        this.zoomMenu.add(this.moveAction);
    }

    private void initRes5() {
        this.res5Action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.model.setResolution(5);
            }
        };
        this.res5Action.putValue("Name", "5");
        this.res5Action.putValue("ShortDescription", "32 X 32 Image");
        this.res5Action.putValue("MnemonicKey", new Integer(53));
        this.resolutionMenu.add(this.res5Action);
    }

    private void initRes6() {
        this.res6Action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.model.setResolution(6);
            }
        };
        this.res6Action.putValue("Name", "6");
        this.res6Action.putValue("ShortDescription", "64 X 64 Image");
        this.res6Action.putValue("MnemonicKey", new Integer(54));
        this.resolutionMenu.add(this.res6Action);
    }

    private void initUnzoom() {
        this.unzoomAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.model.setOperation(2);
            }
        };
        this.unzoomAction.putValue("Name", "Unzoom");
        this.unzoomAction.putValue("ShortDescription", "Zoom out");
        this.unzoomAction.putValue("MnemonicKey", new Integer(85));
        this.zoomMenu.add(this.unzoomAction);
    }

    private void initZoom() {
        this.zoomAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.model.setOperation(1);
            }
        };
        this.zoomAction.putValue("Name", "Zoom");
        this.zoomAction.putValue("ShortDescription", "Zoom in");
        this.zoomAction.putValue("MnemonicKey", new Integer(90));
        this.zoomMenu.add(this.zoomAction);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        Application application = new Application(n);
        application.setDefaultCloseOperation(3);
        application.pack();
        application.setVisible(true);
    }
}

