/*
 * Decompiled with CFR 0.152.
 */
package freak.module.mapper.bitstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.mapper.AbstractMapper;
import freak.core.population.Genotype;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class Permuter_Mapper
extends AbstractMapper
implements BatchEventListener {
    private int[] forwards;
    private int[] backwards;

    public Permuter_Mapper(Schedule schedule) {
        super(schedule);
        if (schedule.getPhenotypeSearchSpace() instanceof BitString) {
            this.createPermutation();
        }
    }

    public void initialize() {
        super.initialize();
        int dimension = ((BitString)this.schedule.getPhenotypeSearchSpace()).getDimension();
        if (this.forwards != null && this.forwards.length != dimension) {
            this.createPermutation();
        }
    }

    public void createPermutation() {
        int dimension = ((BitString)this.schedule.getPhenotypeSearchSpace()).getDimension();
        this.forwards = new int[dimension];
        this.backwards = new int[dimension];
        RandomElement re = this.schedule.getRandomElement();
        int i = 0;
        while (i < dimension) {
            this.forwards[i] = i;
            ++i;
        }
        i = 0;
        while (i < dimension) {
            int j = re.choose(i, dimension - 1);
            int tmp = this.forwards[j];
            this.forwards[j] = this.forwards[i];
            this.forwards[i] = tmp;
            this.backwards[tmp] = i++;
        }
    }

    public Genotype genotypeToPhenotype(Genotype genotype) {
        int dimension = ((BitString)this.schedule.getPhenotypeSearchSpace()).getDimension();
        BitSet phenoBS = new BitSet(dimension);
        BitSet genoBS = ((BitStringGenotype)genotype).getBitSet();
        int i = 0;
        while (i < dimension) {
            phenoBS.set(i, genoBS.get(this.forwards[i]));
            ++i;
        }
        return new BitStringGenotype(phenoBS, dimension);
    }

    public Genotype phenotypeToGenotype(Genotype genotype) {
        if (this.backwards == null) {
            return genotype;
        }
        int dimension = ((BitString)this.schedule.getPhenotypeSearchSpace()).getDimension();
        BitSet genoBS = new BitSet(dimension);
        BitSet phenoBS = ((BitStringGenotype)genotype).getBitSet();
        int i = 0;
        while (i < dimension) {
            genoBS.set(i, phenoBS.get(this.backwards[i]));
            ++i;
        }
        return new BitStringGenotype(genoBS, dimension);
    }

    public SearchSpace getGenotypeSearchSpace() {
        return this.schedule.getPhenotypeSearchSpace();
    }

    public String getName() {
        return "Bit String Permuter";
    }

    public String getDescription() {
        return "Permutes the bits in a randomly created order.";
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    public void batchStarted(BatchEvent evt) {
        this.createPermutation();
    }
}

