/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.booleanfunction;

import freak.Freak;
import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticMultiObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.core.population.Genotype;
import freak.core.util.FreakMath;
import freak.module.searchspace.BooleanFunctionGenotype;
import freak.module.searchspace.logictree.AndNode;
import freak.module.searchspace.logictree.Data;
import freak.module.searchspace.logictree.OperatorNode;
import freak.module.searchspace.logictree.OperatorNodeVector;
import java.util.BitSet;

public class GenericPareto
extends AbstractStaticMultiObjectiveFitnessFunction
implements Configurable {
    private static int bestLengthFound = 42;
    private static int[][] subsetsArray;
    private static int[] baggingArray;
    private static long lastBatchUpdated;
    private static long lastRunUpdated;
    private static long nextUpdate;
    public static final int OBJECTIVE_NONE = 0;
    public static final int OBJECTIVE_CASES = 1;
    public static final int OBJECTIVE_CONTROLS = 2;
    public static final int OBJECTIVE_CASESCONTROLS = 3;
    public static final int OBJECTIVE_LENGTH = 4;
    public static final int OBJECTIVE_STANDARDISED_FITNESS = 5;
    public static final int OBJECTIVE_STANDARDISED_FITNESS_2X_CONTROL = 6;
    public static final int OBJECTIVE_GINI = 7;
    public static final int OBJECTIVE_GINI_NEG = 8;
    public static final int OBJECTIVE_GINI_ON_AND_NODES = 9;
    public static final int OBJECTIVE_GINI_NEG_ON_AND_NODES = 10;
    public static final int OBJECTIVE_AVGRATIO = 11;
    public static final int OBJECTIVE_STANDARDISED_FITNESS_LENGTH = 12;
    public static final int OBJECTIVE_STANDARDISED_FITNESS_IMPLICIT_LENGTH = 13;
    String[] objectives = new String[]{"Cases", "Controls", "Cases+Controls", "Length", "Standardised Fitness", "Standardised Fitness 2xControl", "Gini", "Gini (neg)", "Gini on And-Nodes", "Gini (neg) on And-Nodes", "AvgRatio", "Standardised Fitness with length", "Standardised Fitness with implicit length"};
    private static Schedule staticSchedule;
    private static int subsets;
    private int subsetsUpdate = 0;
    private static int bagging;
    private int baggingUpdate = 0;
    private int length;
    private int dimensionOfObjectiveSpace = 2;
    private boolean predictingModelFound = false;
    private int[] paretoObjective = new int[3];
    private int[] paretoObjectiveForMonomials = new int[3];
    private boolean treatMonomialsDifferent = false;
    private int sizePruning = Integer.MAX_VALUE;
    private int monomialSizePruning = Integer.MAX_VALUE;
    private int monomialPruning = Integer.MAX_VALUE;

    static {
        lastBatchUpdated = -1L;
        lastRunUpdated = -1L;
        nextUpdate = 1L;
        subsets = 1;
        bagging = 0;
    }

    public GenericPareto(Schedule schedule) {
        super(schedule);
        staticSchedule = schedule;
        this.paretoObjective[0] = 1;
        this.paretoObjective[1] = 2;
        this.paretoObjective[2] = 0;
        this.paretoObjectiveForMonomials[0] = 1;
        this.paretoObjectiveForMonomials[1] = 2;
        this.paretoObjectiveForMonomials[2] = 0;
    }

    protected double[] evaluate(Genotype genotype) {
        int objectivesToFulfill = 2;
        if (staticSchedule == null) {
            staticSchedule = this.schedule;
        }
        if (subsets > 1 || bagging > 0) {
            if (lastRunUpdated < (long)this.schedule.getCurrentRun() || lastBatchUpdated < (long)this.schedule.getCurrentBatch()) {
                nextUpdate = this.schedule.getCurrentGeneration();
                lastBatchUpdated = this.schedule.getCurrentBatch();
                lastRunUpdated = this.schedule.getCurrentRun();
            }
            if (subsets > 1 && nextUpdate == (long)this.schedule.getCurrentGeneration()) {
                GenericPareto.newSubsets();
                nextUpdate = this.subsetsUpdate == 0 ? -1L : (nextUpdate += (long)this.subsetsUpdate);
            } else if (bagging > 0 && nextUpdate == (long)this.schedule.getCurrentGeneration()) {
                GenericPareto.newBagging();
                nextUpdate = this.baggingUpdate == 0 ? -1L : (nextUpdate += (long)this.baggingUpdate);
            }
        }
        if (this.paretoObjective[2] != 0) {
            this.dimensionOfObjectiveSpace = 3;
            objectivesToFulfill = 3;
        }
        double[] rueckgabe = new double[this.dimensionOfObjectiveSpace];
        if (genotype instanceof BooleanFunctionGenotype) {
            BooleanFunctionGenotype bfg = (BooleanFunctionGenotype)genotype;
            this.length = bfg.evaluateSize();
            Fulfillment polynomFulfillment = null;
            boolean prune = false;
            if (this.length > this.sizePruning || bfg.getNoOfMonomials() > this.monomialPruning || bfg.getMaximumMonomialSize() > this.monomialSizePruning) {
                prune = true;
            }
            if (!prune) {
                if (subsets > 1 || bagging > 0) {
                    polynomFulfillment = this.doSubsetBaggingComputations(bfg.getCharacteristicBitSet());
                }
                int i = 0;
                while (i < this.dimensionOfObjectiveSpace) {
                    int objective = bfg.getNoOfMonomials() == 1 && this.treatMonomialsDifferent ? this.paretoObjectiveForMonomials[i] : this.paretoObjective[i];
                    switch (objective) {
                        case 1: {
                            int j;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = bfg.evaluate1s();
                            } else {
                                rueckgabe[i] = 2.147483647E9;
                                j = 0;
                                while (j < subsets) {
                                    if ((double)polynomFulfillment.cases[j] < rueckgabe[i]) {
                                        rueckgabe[i] = polynomFulfillment.cases[j];
                                    }
                                    ++j;
                                }
                            }
                            if (rueckgabe[i] != (double)Data.getNum1Rows()) break;
                            --objectivesToFulfill;
                            break;
                        }
                        case 2: {
                            int j;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = bfg.evaluate0s();
                            } else {
                                rueckgabe[i] = 2.147483647E9;
                                j = 0;
                                while (j < subsets) {
                                    if ((double)polynomFulfillment.controls[j] < rueckgabe[i]) {
                                        rueckgabe[i] = polynomFulfillment.controls[j];
                                    }
                                    ++j;
                                }
                            }
                            if (rueckgabe[i] != (double)Data.getNum0Rows()) break;
                            --objectivesToFulfill;
                            break;
                        }
                        case 3: {
                            int j;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = bfg.evaluate();
                            } else {
                                rueckgabe[i] = 2.147483647E9;
                                j = 0;
                                while (j < subsets) {
                                    if ((double)polynomFulfillment.casescontrols[j] < rueckgabe[i]) {
                                        rueckgabe[i] = polynomFulfillment.casescontrols[j];
                                    }
                                    ++j;
                                }
                            }
                            if (rueckgabe[i] != (double)Data.getNumRows()) break;
                            --objectivesToFulfill;
                            break;
                        }
                        case 4: {
                            rueckgabe[i] = -this.length;
                            --objectivesToFulfill;
                            break;
                        }
                        case 5: {
                            double standardisedFitness;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = (double)bfg.evaluate1s() / (double)Data.getNum1Rows() / 2.0 + (double)bfg.evaluate0s() / (double)Data.getNum0Rows() / 2.0;
                                break;
                            }
                            rueckgabe[i] = 2.147483647E9;
                            int j = 0;
                            while (j < subsets) {
                                standardisedFitness = (double)polynomFulfillment.cases[j] / (double)polynomFulfillment.casesInData[j] / 2.0 + (double)polynomFulfillment.controls[j] / (double)polynomFulfillment.controlsInData[j] / 2.0;
                                if (standardisedFitness < rueckgabe[i]) {
                                    rueckgabe[i] = standardisedFitness;
                                }
                                ++j;
                            }
                            break;
                        }
                        case 6: {
                            double standardisedFitness;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = (double)bfg.evaluate1s() / (double)Data.getNum1Rows() * 55.0 / 100.0 + (double)bfg.evaluate0s() / (double)Data.getNum0Rows() * 45.0 / 100.0;
                                break;
                            }
                            rueckgabe[i] = 2.147483647E9;
                            int j = 0;
                            while (j < subsets) {
                                standardisedFitness = (double)polynomFulfillment.cases[j] / (double)polynomFulfillment.casesInData[j] / 3.0 + (double)polynomFulfillment.controls[j] / (double)polynomFulfillment.controlsInData[j] * 2.0 / 3.0;
                                if (standardisedFitness < rueckgabe[i]) {
                                    rueckgabe[i] = standardisedFitness;
                                }
                                ++j;
                            }
                            break;
                        }
                        case 7: {
                            double gini;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = this.getObjectiveGini(bfg, bfg.evaluate1s(), bfg.evaluate0s(), Data.getNum1Rows(), Data.getNum0Rows());
                                break;
                            }
                            rueckgabe[i] = 2.147483647E9;
                            int j = 0;
                            while (j < subsets) {
                                gini = this.getObjectiveGini(bfg, polynomFulfillment.cases[j], polynomFulfillment.controls[j], polynomFulfillment.casesInData[j], polynomFulfillment.controlsInData[j]);
                                if (gini < rueckgabe[i]) {
                                    rueckgabe[i] = gini;
                                }
                                ++j;
                            }
                            break;
                        }
                        case 8: {
                            double gini;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = -this.getObjectiveGini(bfg, bfg.evaluate1s(), bfg.evaluate0s(), Data.getNum1Rows(), Data.getNum0Rows());
                                break;
                            }
                            rueckgabe[i] = 2.147483647E9;
                            int j = 0;
                            while (j < subsets) {
                                gini = -this.getObjectiveGini(bfg, polynomFulfillment.cases[j], polynomFulfillment.controls[j], polynomFulfillment.casesInData[j], polynomFulfillment.controlsInData[j]);
                                if (gini < rueckgabe[i]) {
                                    rueckgabe[i] = gini;
                                }
                                ++j;
                            }
                            break;
                        }
                        case 9: {
                            double gini;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = this.getObjectiveGiniOnAndNodes(bfg, bfg.evaluate1s(), bfg.evaluate0s(), Data.getNum1Rows(), Data.getNum0Rows());
                                break;
                            }
                            rueckgabe[i] = 2.147483647E9;
                            int j = 0;
                            while (j < subsets) {
                                gini = this.getObjectiveGiniOnAndNodes(bfg, polynomFulfillment.cases[j], polynomFulfillment.controls[j], polynomFulfillment.casesInData[j], polynomFulfillment.controlsInData[j]);
                                if (gini < rueckgabe[i]) {
                                    rueckgabe[i] = gini;
                                }
                                ++j;
                            }
                            break;
                        }
                        case 10: {
                            double gini;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = -this.getObjectiveGiniOnAndNodes(bfg, bfg.evaluate1s(), bfg.evaluate0s(), Data.getNum1Rows(), Data.getNum0Rows());
                                break;
                            }
                            rueckgabe[i] = 2.147483647E9;
                            int j = 0;
                            while (j < subsets) {
                                gini = -this.getObjectiveGiniOnAndNodes(bfg, polynomFulfillment.cases[j], polynomFulfillment.controls[j], polynomFulfillment.casesInData[j], polynomFulfillment.controlsInData[j]);
                                if (gini < rueckgabe[i]) {
                                    rueckgabe[i] = gini;
                                }
                                ++j;
                            }
                            break;
                        }
                        case 11: {
                            rueckgabe[i] = this.getObjectiveAvgRatio(bfg);
                            break;
                        }
                        case 12: {
                            double standardisedFitness;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = (double)bfg.evaluate1s() / (double)Data.getNum1Rows() / 3.0 + (double)bfg.evaluate0s() / (double)Data.getNum0Rows() / 3.0 + (double)(this.sizePruning - this.length + 1) / (double)this.sizePruning / 3.0;
                                break;
                            }
                            rueckgabe[i] = 2.147483647E9;
                            int j = 0;
                            while (j < subsets) {
                                standardisedFitness = (double)polynomFulfillment.cases[j] / (double)polynomFulfillment.casesInData[j] / 3.0 + (double)polynomFulfillment.controls[j] / (double)polynomFulfillment.controlsInData[j] / 3.0 + (double)(this.sizePruning - this.length + 1) / (double)this.sizePruning / 3.0;
                                if (standardisedFitness < rueckgabe[i]) {
                                    rueckgabe[i] = standardisedFitness;
                                }
                                ++j;
                            }
                            break;
                        }
                        case 13: {
                            double standardisedFitness;
                            if (subsets == 1 && bagging == 0) {
                                rueckgabe[i] = (double)bfg.evaluate1s() / (double)Data.getNum1Rows() + (double)bfg.evaluate0s() / (double)Data.getNum0Rows() - (double)this.length / ((double)this.sizePruning * (double)Data.getNumRows());
                                break;
                            }
                            rueckgabe[i] = 2.147483647E9;
                            int j = 0;
                            while (j < subsets) {
                                standardisedFitness = (double)polynomFulfillment.cases[j] / (double)polynomFulfillment.casesInData[j] + (double)polynomFulfillment.controls[j] / (double)polynomFulfillment.controlsInData[j] - (double)this.length / ((double)this.sizePruning * (double)Data.getNumRows());
                                if (standardisedFitness < rueckgabe[i]) {
                                    rueckgabe[i] = standardisedFitness;
                                }
                                ++j;
                            }
                            break;
                        }
                    }
                    ++i;
                }
                this.schedule.getCurrentGeneration();
                if (objectivesToFulfill == 0) {
                    this.predictingModelFound = true;
                    if (this.length < bestLengthFound) {
                        bestLengthFound = this.length;
                    }
                }
            } else {
                rueckgabe[0] = -2.147483648E9;
                rueckgabe[1] = -2.147483648E9;
                if (this.dimensionOfObjectiveSpace == 3) {
                    rueckgabe[2] = -2.147483648E9;
                }
            }
        } else {
            rueckgabe[0] = 0.0;
            rueckgabe[1] = 0.0;
            if (this.dimensionOfObjectiveSpace == 3) {
                rueckgabe[2] = 0.0;
            }
        }
        return rueckgabe;
    }

    private Fulfillment doSubsetBaggingComputations(BitSet treeBitSet) {
        Fulfillment f = new Fulfillment(subsets);
        BitSet resultBitSet = Data.getResultBitSet();
        int i = 0;
        while (i < subsets) {
            ((Fulfillment)f).cases[i] = 0;
            ((Fulfillment)f).controls[i] = 0;
            ((Fulfillment)f).casesInData[i] = 0;
            ((Fulfillment)f).controlsInData[i] = 0;
            int[] subset = subsets == 1 ? baggingArray : subsetsArray[i];
            int j = 0;
            while (j < subset.length) {
                if (subset[j] != -1) {
                    if (resultBitSet.get(subset[j])) {
                        int[] nArray = f.casesInData;
                        int n = i;
                        nArray[n] = nArray[n] + 1;
                        if (treeBitSet.get(subset[j])) {
                            int[] nArray2 = f.cases;
                            int n2 = i;
                            nArray2[n2] = nArray2[n2] + 1;
                        }
                    } else {
                        int[] nArray = f.controlsInData;
                        int n = i;
                        nArray[n] = nArray[n] + 1;
                        if (!treeBitSet.get(subset[j])) {
                            int[] nArray3 = f.controls;
                            int n3 = i;
                            nArray3[n3] = nArray3[n3] + 1;
                        }
                    }
                }
                ++j;
            }
            ((Fulfillment)f).casescontrols[i] = f.cases[i] + f.controls[i];
            ++i;
        }
        return f;
    }

    private double getObjectiveGini(BooleanFunctionGenotype bfg, int num1s, int num0s, int numCases, int numControls) {
        double gini = 0.0;
        double p = 0.0;
        if (bfg.getNoOfMonomials() == 0) {
            gini = -1.0;
        } else {
            double right1s = (double)num1s / (double)numCases;
            double wrong0s = (double)(numControls - num0s) / (double)numControls;
            if (right1s + wrong0s > 0.0) {
                p = right1s / (right1s + wrong0s);
            }
            gini = 2.0 * p * (1.0 - p);
        }
        return gini;
    }

    private double getObjectiveGiniOnAndNodes(BooleanFunctionGenotype bfg, int num1s, int num0s, int numCases, int numControls) {
        double sum = 0.0;
        double p_0 = (double)bfg.getDnfbaum().getNumControlsExplainedByNoOne() / (double)(numCases + numControls - num0s - num1s);
        sum += 2.0 * p_0 * (1.0 - p_0);
        int i = 0;
        while (i < bfg.getNoOfMonomials()) {
            double num0s_i = (double)(numControls - bfg.getDnfbaum().getNumWrongControls(i)) / (double)numControls;
            double num1s_i = (double)bfg.getDnfbaum().getNumFullfilledCases(i) / (double)numCases;
            double p_i = num1s_i > 0.0 ? num1s_i / (num0s_i + num1s_i) : 0.0;
            sum += 2.0 * p_i * (1.0 - p_i);
            ++i;
        }
        return sum;
    }

    private double getObjectiveAvgRatio(BooleanFunctionGenotype bfg) {
        double ratio = 0.0;
        double num1 = Data.getNum1Rows();
        double num0 = Data.getNum0Rows();
        if (bfg.getDnfbaum().getNoOfMonomials() == 0) {
            ratio = -1.0;
        } else if (subsets == 1 && bagging == 0) {
            int i = 0;
            while (i < bfg.getDnfbaum().getNoOfMonomials()) {
                int fCases = bfg.getDnfbaum().getNumFullfilledCases(i);
                int wControls = bfg.getDnfbaum().getNumWrongControls(i);
                int length = bfg.getDnfbaum().getNumLiteralsInMonom(i);
                ratio += (double)fCases / num1 / ((double)fCases / num1 + (double)(wControls + 1) / num0);
                ++i;
            }
            ratio = ratio / (double)bfg.getDnfbaum().getNoOfMonomials() / (double)bfg.getDnfbaum().getNoOfMonomials();
            ratio = 2.0 * ratio * (1.0 - ratio);
        } else {
            OperatorNodeVector monomials = bfg.getAllUsedAndNodes();
            OperatorNode[] monomialsArray = monomials.toArray();
            ratio = 2.147483647E9;
            int j = 0;
            while (j < subsets) {
                int subsetRatio = 0;
                int i = 0;
                while (i < monomialsArray.length) {
                    AndNode nextNode = (AndNode)monomialsArray[i];
                    Fulfillment monomialFulfillment = this.doSubsetBaggingComputations(nextNode.getValueBitset());
                    subsetRatio = (int)((double)subsetRatio + (double)monomialFulfillment.cases[j] / (double)monomialFulfillment.casesInData[j] / ((double)(monomialFulfillment.controlsInData[j] - monomialFulfillment.controls[j] + 1) / (double)monomialFulfillment.controlsInData[j]));
                    ++i;
                }
                if ((double)(subsetRatio = subsetRatio / bfg.getDnfbaum().getNoOfMonomials() / bfg.getDnfbaum().getNoOfMonomials()) < ratio) {
                    ratio = subsetRatio;
                }
                ++j;
            }
        }
        return ratio;
    }

    public static void newBagging() {
        if (bagging > 0) {
            baggingArray = FreakMath.getKofN(staticSchedule, Data.getNumRows() - bagging, Data.getNumRows());
        }
    }

    public static void newSubsets() {
        if (subsets > 1) {
            subsetsArray = FreakMath.getKDisjointSetsOfNNumbersExcludeH(staticSchedule, subsets, Data.getNumRows(), bagging);
        }
    }

    public int getDimensionOfObjectiveSpace() {
        return this.dimensionOfObjectiveSpace;
    }

    public String getName() {
        return "Generic Pareto";
    }

    public String getDescription() {
        return "Generic customisable Pareto fitness";
    }

    public void setPropertyParetoObjective0(StringArrayWrapper saw) {
        this.paretoObjective[0] = saw.getIndex() + 1;
    }

    public StringArrayWrapper getPropertyParetoObjective0() {
        return new StringArrayWrapper(this.objectives, this.paretoObjective[0] - 1);
    }

    public String getShortDescriptionForParetoObjective0() {
        return "1.1 1st Pareto Objective";
    }

    public String getLongDescriptionForParetoObjective0() {
        return "First Pareto Objective.";
    }

    public void setPropertyParetoObjective1(StringArrayWrapper saw) {
        this.paretoObjective[1] = saw.getIndex() + 1;
    }

    public StringArrayWrapper getPropertyParetoObjective1() {
        return new StringArrayWrapper(this.objectives, this.paretoObjective[1] - 1);
    }

    public String getShortDescriptionForParetoObjective1() {
        return "1.2 2nd Pareto Objective";
    }

    public String getLongDescriptionForParetoObjective1() {
        return "Second Pareto Objective.";
    }

    public void setPropertyParetoObjective2(StringArrayWrapper saw) {
        this.paretoObjective[2] = saw.getIndex();
    }

    public StringArrayWrapper getPropertyParetoObjective2() {
        String[] objectivesPlusNone = new String[this.objectives.length + 1];
        objectivesPlusNone[0] = "-";
        int i = 0;
        while (i < this.objectives.length) {
            objectivesPlusNone[i + 1] = this.objectives[i];
            ++i;
        }
        return new StringArrayWrapper(objectivesPlusNone, this.paretoObjective[2]);
    }

    public String getShortDescriptionForParetoObjective2() {
        return "1.3 3rd Pareto Objective";
    }

    public String getLongDescriptionForParetoObjective2() {
        return "Third Pareto Objective.";
    }

    public void setPropertyTreatMonomialsDifferent(boolean treatMonomialsDifferent) {
        this.treatMonomialsDifferent = treatMonomialsDifferent;
    }

    public boolean getPropertyTreatMonomialsDifferent() {
        return this.treatMonomialsDifferent;
    }

    public String getShortDescriptionForTreatMonomialsDifferent() {
        return "2   Treat monomials different?";
    }

    public String getLongDescriptionForTreatMonomialsDifferent() {
        return "Flag to set up if monomials should have different objectives.";
    }

    public void setPropertyParetoObjectiveForMonomials0(StringArrayWrapper saw) {
        this.paretoObjectiveForMonomials[0] = saw.getIndex() + 1;
    }

    public StringArrayWrapper getPropertyParetoObjectiveForMonomials0() {
        return new StringArrayWrapper(this.objectives, this.paretoObjectiveForMonomials[0] - 1);
    }

    public String getShortDescriptionForParetoObjectiveForMonomials0() {
        return "2.1 1st Pareto Objective for monomial";
    }

    public String getLongDescriptionForParetoObjectiveForMonomials0() {
        return "First Pareto Objective for monomial.";
    }

    public void setPropertyParetoObjectiveForMonomials1(StringArrayWrapper saw) {
        this.paretoObjectiveForMonomials[1] = saw.getIndex() + 1;
    }

    public StringArrayWrapper getPropertyParetoObjectiveForMonomials1() {
        return new StringArrayWrapper(this.objectives, this.paretoObjectiveForMonomials[1] - 1);
    }

    public String getShortDescriptionForParetoObjectiveForMonomials1() {
        return "2.2 2nd Pareto Objective for monomial";
    }

    public String getLongDescriptionForParetoObjectiveForMonomials1() {
        return "Second Pareto Objective for monomial.";
    }

    public void setPropertyParetoObjectiveForMonomials2(StringArrayWrapper saw) {
        this.paretoObjectiveForMonomials[2] = saw.getIndex();
    }

    public StringArrayWrapper getPropertyParetoObjectiveForMonomials2() {
        String[] objectivesPlusNone = new String[this.objectives.length + 1];
        objectivesPlusNone[0] = "-";
        int i = 0;
        while (i < this.objectives.length) {
            objectivesPlusNone[i + 1] = this.objectives[i];
            ++i;
        }
        return new StringArrayWrapper(objectivesPlusNone, this.paretoObjectiveForMonomials[2]);
    }

    public String getShortDescriptionForParetoObjectiveForMonomials2() {
        return "2.3 3rd Pareto Objective for monomial";
    }

    public String getLongDescriptionForParetoObjectiveForMonomials2() {
        return "Third Pareto Objective for monomial.";
    }

    public Integer getPropertySubsets() {
        return new Integer(subsets);
    }

    public void setPropertySubsets(Integer subsets) {
        GenericPareto.subsets = subsets;
        Freak.debug("Subsets set to " + GenericPareto.subsets, 4);
    }

    public String getShortDescriptionForSubsets() {
        return "3.1 Subsets";
    }

    public String getLongDescriptionForSubsets() {
        return "Number of randomly chosen subsets of the data. Has no effect on the objectives " + this.objectives[3] + " and " + this.objectives[10] + ".";
    }

    public Integer getPropertySubsetsUpdate() {
        return new Integer(this.subsetsUpdate);
    }

    public void setPropertySubsetsUpdate(Integer subsetsUpdate) {
        this.subsetsUpdate = subsetsUpdate;
    }

    public String getShortDescriptionForSubsetsUpdate() {
        return "3.2 Update Subsets";
    }

    public String getLongDescriptionForSubsetsUpdate() {
        return "Update Subsets every x generations (x=0: never update).";
    }

    public Integer getPropertyBagging() {
        return new Integer(bagging);
    }

    public void setPropertyBagging(Integer bagging) {
        GenericPareto.bagging = bagging;
    }

    public String getShortDescriptionForBagging() {
        return "4.1 Bagging";
    }

    public String getLongDescriptionForBagging() {
        return "Number of randomly excluded values of the data. Has no effect on the objectives " + this.objectives[3] + " and " + this.objectives[10] + ".";
    }

    public Integer getPropertyBaggingUpdate() {
        return new Integer(this.baggingUpdate);
    }

    public void setPropertyBaggingUpdate(Integer baggingUpdate) {
        this.baggingUpdate = baggingUpdate;
    }

    public String getShortDescriptionForBaggingUpdate() {
        return "4.2 Update Bagging";
    }

    public String getLongDescriptionForBaggingUpdate() {
        return "Update Bagging every x generations (x=0: never update). Gets overridden by Update Subsets if subsets are activated";
    }

    public Integer getPropertySizePruning() {
        return new Integer(this.sizePruning);
    }

    public void setPropertySizePruning(Integer sizePruning) {
        this.sizePruning = sizePruning;
    }

    public String getShortDescriptionForSizePruning() {
        return "5.1 Size pruning";
    }

    public String getLongDescriptionForSizePruning() {
        return "Size bound for pruning.";
    }

    public Integer getPropertyMonomialSizePruning() {
        return new Integer(this.monomialSizePruning);
    }

    public void setPropertyMonomialSizePruning(Integer monomialSizePruning) {
        this.monomialSizePruning = monomialSizePruning;
    }

    public String getShortDescriptionForMonomialSizePruning() {
        return "5.2 Monomial size pruning";
    }

    public String getLongDescriptionForMonomialSizePruning() {
        return "Size bound for single monomials for pruning.";
    }

    public Integer getPropertyMonomialPruning() {
        return new Integer(this.monomialPruning);
    }

    public void setPropertyMonomialPruning(Integer monomialPruning) {
        this.monomialPruning = monomialPruning;
    }

    public String getShortDescriptionForMonomialPruning() {
        return "5.3 Monomial number pruning";
    }

    public String getLongDescriptionForMonomialPruning() {
        return "Bound on the number of monomials for pruning.";
    }

    public void setParetoObjective(int[] paretoObjective) {
        this.paretoObjective = paretoObjective;
    }

    public void setParetoObjectiveForMonomials(int[] paretoObjectiveForMonomials) {
        this.paretoObjectiveForMonomials = paretoObjectiveForMonomials;
    }

    public boolean isPredictingModelFound() {
        return this.predictingModelFound;
    }

    public void setPredictingModelFound(boolean predictingModelFound) {
        this.predictingModelFound = predictingModelFound;
    }

    private class Fulfillment {
        private int[] cases;
        private int[] controls;
        private int[] casescontrols;
        private int[] casesInData;
        private int[] controlsInData;

        public Fulfillment(int subsets) {
            this.cases = new int[subsets];
            this.controls = new int[subsets];
            this.casescontrols = new int[subsets];
            this.casesInData = new int[subsets];
            this.controlsInData = new int[subsets];
        }
    }
}

