/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.core.control.Schedule;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.fitness.pointset.AbstractSingleObjectiveRobustRegressionFitness;
import freak.module.fitness.pointset.WrongNumberOfPointsException;
import freak.rinterface.model.RReturns;

public abstract class AbstractStaticSingleObjectiveRobustRegressionFitness
extends AbstractSingleObjectiveRobustRegressionFitness {
    public AbstractStaticSingleObjectiveRobustRegressionFitness(Schedule schedule) {
        super(schedule);
    }

    public final double evaluate(Individual individual, IndividualList list) {
        Double[] d = individual.getLatestKnownFitnessValue();
        if (d != null) {
            return d[0];
        }
        double fitness = this.evaluate(individual.getPhenotype());
        Double[] result = new Double[]{new Double(fitness)};
        individual.setLatestKnownFitnessValue(result);
        return fitness;
    }

    protected double evaluate(Genotype genotype) {
        try {
            this.calculateResiduals(genotype);
        }
        catch (WrongNumberOfPointsException e) {
            return e.getErrorFitnessValue() + this.offset;
        }
        this.adjustHyperplane(genotype);
        if (this.interceptAdjust) {
            this.adjustIntercept(genotype);
        }
        double evaluation = this.evaluateResiduals();
        this.rememberChoosenParameters();
        if (-evaluation < RReturns.getResidual()) {
            RReturns.setResidual(-evaluation);
            RReturns.setChosenIndices(this.chosenIndices);
            RReturns.setFittedHyperplane(this.fittedHyperplane);
        }
        return evaluation;
    }

    protected void adjustIntercept(Genotype genotype) {
    }

    public int compareIndividuals(Individual ind1, Individual ind2) throws UnsupportedOperationException {
        double f2;
        if (ind1 == ind2) {
            return 0;
        }
        double f1 = this.evaluate(ind1, null);
        if (f1 > (f2 = this.evaluate(ind2, null))) {
            return 1;
        }
        if (f1 < f2) {
            return -1;
        }
        return 0;
    }
}

