/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.searchspace.HasMetric;

public class ProgressRate
extends AbstractObserver
implements IndividualListEventListener,
RunEventListener,
Configurable {
    private Double lastAverageDistance;

    public ProgressRate(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        try {
            schedule.getFitnessFunction().getGenotypeOptimum();
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedEnvironmentException("Global optimum is unknown.");
        }
        if (!(schedule.getGenotypeSearchSpace() instanceof HasMetric)) {
            throw new UnsupportedEnvironmentException("Search space has no metric.");
        }
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public String getName() {
        return "Progress Rate";
    }

    public String getDescription() {
        return "Computes the progress rate, the difference between the average distance to the global optimum of the current population and last generation's population.";
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        HasMetric searchSpace = (HasMetric)((Object)this.getSchedule().getGenotypeSearchSpace());
        Genotype optimum = this.getSchedule().getFitnessFunction().getGenotypeOptimum();
        double sum = 0.0;
        int i = 0;
        while (i < individuals.length) {
            sum += searchSpace.getDistance(individuals[i].getGenotype(), optimum);
            ++i;
        }
        double average = sum / (double)individuals.length;
        double result = 0.0;
        if (this.lastAverageDistance != null) {
            result = this.lastAverageDistance - average;
        }
        this.lastAverageDistance = new Double(average);
        this.updateViews(new Double(result));
    }

    public void runStarted(RunEvent evt) {
        this.lastAverageDistance = null;
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.schedule.getPopulationManager());
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }
}

