/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.modulesupport.ClassCollector;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.core.population.Genotype;
import freak.core.searchspace.AbstractSearchSpace;
import freak.core.searchspace.HasDimension;
import freak.module.fitness.pointset.LtSFile;
import freak.module.searchspace.PointSetGenotype;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class PointSet
extends AbstractSearchSpace
implements Configurable,
HasDimension {
    String[] ltsFileListCache = null;
    Object[] ltsFileArrayCache = null;
    int m_zLtSChoice = 0;
    public static boolean pointsSetFromR = false;
    private int dimension = 4;
    private int pointDimension = 2;
    protected Point[] m_hPoints;
    private boolean m_zRandomPoints = true;
    RandomElement re;

    public PointSet(Schedule schedule) {
        super(schedule);
        this.re = schedule.getRandomElement();
        this.initRandomPoints();
    }

    private void initRandomPoints() {
        this.m_hPoints = new Point[this.dimension];
        int i = 0;
        while (i < this.dimension) {
            this.m_hPoints[i] = new Point(this.pointDimension, this.re);
            ++i;
        }
    }

    public void setPoints(Point[] points) {
        this.m_hPoints = points;
        if (points != null) {
            this.pointDimension = points[0].getDimension();
            this.dimension = points.length;
            this.schedule.callInitialize();
        }
    }

    public Genotype getRandomGenotype() {
        RandomElement re = this.schedule.getRandomElement();
        boolean[] selection = new boolean[this.dimension];
        int i = 0;
        while (i < this.dimension) {
            if (re.choose(2) == 1) {
                selection[i] = true;
            }
            ++i;
        }
        return new PointSetGenotype(this.m_hPoints, selection);
    }

    public int getDimension() {
        return this.dimension;
    }

    public Point[] getPoints() {
        return this.m_hPoints;
    }

    private String[] createLTSFileList() {
        int i;
        if (this.ltsFileListCache != null) {
            return this.ltsFileListCache;
        }
        String[] classpaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        String startedFrom = ClassCollector.getStartedFrom();
        if (startedFrom.toLowerCase().endsWith(".jar")) {
            String resDir = String.valueOf(startedFrom.substring(0, startedFrom.lastIndexOf("/") + 1)) + "resource";
            classpaths = new String[]{resDir};
        }
        LinkedList<CommonFileInfo> auswahl = new LinkedList<CommonFileInfo>();
        int cp = 0;
        while (cp < classpaths.length) {
            File ltsFolder = new File(String.valueOf(classpaths[cp]) + "/freak/module/fitness/pointset");
            if (ltsFolder.exists()) {
                File[] files = ltsFolder.listFiles(new CommonFileFilter(".csv"));
                i = 0;
                while (i < files.length) {
                    auswahl.add(new CommonFileInfo(files[i], 4));
                    ++i;
                }
            }
            ++cp;
        }
        Object[] o = auswahl.toArray();
        Arrays.sort(o);
        this.ltsFileArrayCache = o;
        LtSFile lts = null;
        try {
            lts = new LtSFile(((CommonFileInfo)this.ltsFileArrayCache[this.m_zLtSChoice]).file);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.setRandomPoints(false);
        if (!pointsSetFromR) {
            this.pointDimension = lts.getPointDimension();
            this.dimension = lts.getDimension();
            this.m_hPoints = lts.getPointData();
            this.schedule.callInitialize();
        }
        String[] result = new String[o.length];
        i = 0;
        while (i < o.length) {
            result[i] = o[i].toString();
            ++i;
        }
        this.ltsFileListCache = result;
        return result;
    }

    public synchronized StringArrayWrapper getPropertyPoints() {
        return new StringArrayWrapper(this.createLTSFileList(), this.m_zLtSChoice);
    }

    public synchronized void setPropertyPoints(StringArrayWrapper wrapper) {
        LtSFile lts;
        int i = wrapper.getIndex();
        try {
            lts = new LtSFile(((CommonFileInfo)this.ltsFileArrayCache[i]).file);
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        this.setRandomPoints(false);
        if (!pointsSetFromR) {
            this.pointDimension = lts.getPointDimension();
            this.dimension = lts.getDimension();
            this.m_hPoints = lts.getPointData();
            this.schedule.callInitialize();
        }
        this.m_zLtSChoice = i;
    }

    public String getShortDescriptionForPoints() {
        return "Data";
    }

    public void setRandomPoints(boolean random) {
        this.m_zRandomPoints = random;
    }

    public double getSize() {
        return Math.pow(2.0, this.dimension);
    }

    public String getDescription() {
        return "The search space of all subsets of a given set of points in R^d. \nThis searchspace has to be mapped to \"Bit String\" in step 3 (\"Select Genotype-Mapper\"), because it has no seperate adaption operators.\u00a0";
    }

    public String getName() {
        return "Subsets of Points";
    }

    public int getPointDimension() {
        return this.pointDimension;
    }

    public static void setPointsSetFromR(boolean pointsSetFromR) {
        PointSet.pointsSetFromR = pointsSetFromR;
    }

    private static class CommonFileFilter
    implements FileFilter {
        String endtag;

        public CommonFileFilter(String endTag) {
            this.endtag = endTag;
        }

        public boolean accept(File file) {
            return file.getName().endsWith(this.endtag);
        }
    }

    class CommonFileInfo
    implements Comparable,
    Serializable {
        File file;
        String name;

        public CommonFileInfo(File f, int hide) {
            String tspName = f.getName();
            this.name = tspName.substring(0, tspName.length() - 4).toUpperCase();
            this.file = f;
        }

        public int compareTo(Object o) {
            return this.name.compareTo(((CommonFileInfo)o).name);
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Point
    implements Serializable {
        private int dimension;
        private double[] komponents = null;

        public Point(int dimension) {
            this.komponents = new double[dimension];
            this.dimension = dimension;
        }

        public Point(int dimension, RandomElement re) {
            this.komponents = new double[dimension];
            this.dimension = dimension;
            int i = 0;
            while (i < dimension) {
                this.komponents[i] = re.gaussian(42.0);
                ++i;
            }
        }

        public Point(double[] komponents) {
            this.komponents = new double[komponents.length];
            this.dimension = komponents.length;
            int i = 0;
            while (i < this.dimension) {
                this.komponents[i] = komponents[i];
                ++i;
            }
        }

        public Point(Collection<Double> komponents) {
            this.komponents = new double[komponents.size()];
            this.dimension = komponents.size();
            int i = 0;
            Iterator<Double> it = komponents.iterator();
            while (it.hasNext()) {
                this.komponents[i] = it.next();
                ++i;
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Point)) {
                return false;
            }
            Point po = (Point)o;
            if (po.dimension != this.dimension) {
                return false;
            }
            int i = 0;
            while (i < this.dimension) {
                if (po.komponents[i] != this.komponents[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public double getK(int i) {
            return this.komponents[i];
        }

        public void setK(int i, double v) {
            this.komponents[i] = v;
        }

        public int getDimension() {
            return this.dimension;
        }

        public String toString() {
            String result = "(";
            int i = 0;
            while (i < this.dimension - 1) {
                result = String.valueOf(result) + this.komponents[i] + " ";
                ++i;
            }
            result = String.valueOf(result) + this.komponents[this.dimension - 1] + ")";
            return result;
        }
    }
}

