/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace.logictree;

import freak.core.control.Schedule;
import freak.module.searchspace.logictree.AndNode;
import freak.module.searchspace.logictree.Data;
import freak.module.searchspace.logictree.MultipleOperatorNode;
import freak.module.searchspace.logictree.OperatorNode;
import freak.module.searchspace.logictree.OperatorNodeVector;
import freak.module.searchspace.logictree.OrNode;
import freak.module.searchspace.logictree.StaticCompareNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;

public class DNFTree
implements Serializable {
    private final int xyRange;
    private final int maxPercent;
    private boolean emptyAndsForbidden;
    private boolean emptyTreeForbidden;
    private String inputFilePath;
    private static int currentBatch;
    private Schedule schedule;
    private OrNode root;
    private short[] count;
    private short noFulfilledLines = 0;
    private short noFulfilled1Lines = 0;
    private int population = 0;

    public DNFTree(String inputFilePath, Schedule schedule, int population, boolean neuLaden) {
        this(new short[0], 0, 0, new OrNode(), 3, 100, true, true, inputFilePath, schedule, population, neuLaden);
        if (this.emptyTreeForbidden) {
            this.insertAndWithCompare();
        }
    }

    public DNFTree(short[] count, short noFulfilledLines, short noFulfilled1Lines, OrNode o, int xyRange, int maxPercent, boolean emptyAndsForbidden, boolean emptyTreeForbidden, String inputFilePath, Schedule schedule, int population, boolean neuLaden) {
        this.root = o;
        this.xyRange = xyRange;
        this.maxPercent = maxPercent;
        this.emptyAndsForbidden = emptyAndsForbidden;
        this.emptyTreeForbidden = emptyTreeForbidden;
        this.inputFilePath = inputFilePath;
        this.schedule = schedule;
        this.population = population;
        Data.setRandomElement(schedule);
        if (schedule.getCurrentBatch() > currentBatch || neuLaden) {
            currentBatch = schedule.getCurrentBatch();
            Data.setDataLocation(inputFilePath);
            try {
                Data.readData();
            }
            catch (IOException e) {
                System.out.println("Unknown read error. Path set correctly ?");
            }
        }
        if (count.length == 0) {
            this.count = new short[Data.getNumRows()];
            this.noFulfilledLines = 0;
            this.noFulfilled1Lines = 0;
            int i = 0;
            while (i < this.count.length) {
                this.count[i] = 0;
                if (this.count[i] == 1 == Data.getResultOfNr(i)) {
                    this.noFulfilledLines = (short)(this.noFulfilledLines + 1);
                    if (this.count[i] == 1) {
                        this.noFulfilled1Lines = (short)(this.noFulfilled1Lines + 1);
                    }
                }
                ++i;
            }
        } else {
            this.count = new short[count.length];
            int i = 0;
            while (i < count.length) {
                this.count[i] = count[i];
                ++i;
            }
            this.noFulfilledLines = noFulfilledLines;
            this.noFulfilled1Lines = noFulfilled1Lines;
        }
    }

    public int getNumFullfilledCases(int andNode) {
        AndNode an = (AndNode)this.root.getChildAt(andNode);
        BitSet monom = an.getValueBitset();
        monom.and(Data.lineValues);
        int numFullfilledCases = monom.cardinality();
        return numFullfilledCases;
    }

    public int getNumWrongControls(int andNode) {
        AndNode an = (AndNode)this.root.getChildAt(andNode);
        BitSet monom = an.getValueBitset();
        BitSet data = (BitSet)Data.lineValues.clone();
        data.flip(0, data.length());
        monom.and(data);
        int numFullfilledCases = monom.cardinality();
        return numFullfilledCases;
    }

    public int getNumControlsExplainedByNoOne() {
        BitSet result = new BitSet(this.count.length);
        result.clear();
        result.flip(0, result.length());
        int i = 0;
        while (i < this.getNoOfMonomials()) {
            AndNode an = (AndNode)this.root.getChildAt(i);
            result.and(an.getValueBitset());
            ++i;
        }
        BitSet dataStatus = (BitSet)Data.getResultBitSet().clone();
        dataStatus.flip(0, dataStatus.length());
        result.and(dataStatus);
        int numControlsExplainedByNoOne = result.cardinality();
        return numControlsExplainedByNoOne;
    }

    public int getNumLiteralsInMonom(int andNode) {
        AndNode an = (AndNode)this.root.getChildAt(andNode);
        return an.getNumberOfChildren();
    }

    public int evaluate() {
        return this.noFulfilledLines;
    }

    public BitSet getFullfilledLines() {
        BitSet testit = (BitSet)this.root.getValueBitset().clone();
        testit.xor(Data.lineValues);
        testit.flip(0, this.root.numRows);
        return testit;
    }

    public int evaluate1s() {
        return this.noFulfilled1Lines;
    }

    public int evaluate0s() {
        return this.noFulfilledLines - this.noFulfilled1Lines;
    }

    public BitSet getCharacteristicBitSet() {
        BitSet result = new BitSet(this.count.length);
        int i = 0;
        while (i < this.count.length) {
            if (this.count[i] > 0) {
                result.set(i);
            }
            ++i;
        }
        return result;
    }

    public int[] getCharacteristicIntSet() {
        int[] result = new int[this.count.length];
        int i = 0;
        while (i < this.count.length) {
            result[i] = this.count[i] > 0 ? 1 : 0;
            ++i;
        }
        return result;
    }

    public BitSet getBitset() {
        BitSet result = new BitSet(this.count.length);
        result = Data.getResultBitSet();
        BitSet countSet = this.getCharacteristicBitSet();
        result.xor(countSet);
        result.flip(0, Data.getNumRows());
        return result;
    }

    public int getOptFitness() {
        return Data.getNumRows();
    }

    public int getNum1Rows() {
        return Data.getNum1Rows();
    }

    public int getNum0Rows() {
        return Data.getNum0Rows();
    }

    public int getTreeSize() {
        return this.root.getSubtreeSize();
    }

    public int getMaximumMonomialSize() {
        return this.root.getMaximumMonomialSize();
    }

    public int getNoOfMonomials() {
        return this.root.getNumberOfChildren();
    }

    public MultipleOperatorNode getRoot() {
        return this.root;
    }

    public int getPopulation() {
        return this.population;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public void setPopulation(int population) {
        this.population = population;
    }

    private void rootCheck() {
        if (this.root == null) {
            throw new RuntimeException("Root is null!");
        }
    }

    private void AndNodeCheck(AndNode an) {
        this.rootCheck();
        if (an == null) {
            return;
        }
        if (!this.root.contains(an)) {
            throw new RuntimeException("This node is not in the tree!");
        }
    }

    private void AndNodeCheck(int index) {
        this.rootCheck();
        if (this.root.getChildAt(index) == null) {
            throw new RuntimeException("This node is not in the tree!");
        }
    }

    private void AndPlusCompareNodeCheck(AndNode an, StaticCompareNode cn) {
        this.AndNodeCheck(an);
        if (!an.contains(cn)) {
            throw new RuntimeException("This StaticCompareNode is not a child of this AndNode!");
        }
    }

    private void AndPlusCompareNodeCheck(int index1, int index2) {
        this.AndNodeCheck(index1);
        if (((AndNode)this.root.getChildAt(index1)).getChildAt(index2) == null) {
            throw new RuntimeException("This StaticCompareNode is not a child of this AndNode!");
        }
    }

    private void CompareNodeValidCheck(StaticCompareNode cn) {
        if (!Data.compareNodeValid(cn)) {
            throw new RuntimeException("This StaticCompareNode is not known!");
        }
    }

    public AndNode getUsedAndNodeRandomly() {
        AndNode an = this.root.getRandomChildAnd();
        if (an != null) {
            return an;
        }
        return null;
    }

    public OperatorNodeVector getCopyOfAllUsedAndNodes() {
        this.rootCheck();
        return this.root.getCopyOfChildren();
    }

    public OperatorNodeVector getAllUsedAndNodes() {
        this.rootCheck();
        return this.root.getChildren();
    }

    public StaticCompareNode getUsedCompareNodeRandomly(AndNode an) {
        this.AndNodeCheck(an);
        if (an == null) {
            return null;
        }
        StaticCompareNode cn = an.getRandomChildComp();
        if (cn != null) {
            return cn;
        }
        return null;
    }

    public OperatorNodeVector getCopyOfAllUsedCompareNodes(AndNode an) {
        this.AndNodeCheck(an);
        return an.getCopyOfChildren();
    }

    public AndNode getEmptyAndNode() {
        return new AndNode();
    }

    public AndNode getNewAndNodeWithCompareNode() {
        AndNode an = new AndNode();
        StaticCompareNode cn = Data.getExistingCompareNodeRandomly();
        an.addChild(cn);
        return an;
    }

    public StaticCompareNode getExistingCompareNodeRandomly() {
        return Data.getExistingCompareNodeRandomly();
    }

    private void subBitSetFromCount(BitSet bs) {
        int noOfRows = Data.getNumRows();
        int i = 0;
        while (i < noOfRows) {
            if (bs.get(i)) {
                int n = i;
                this.count[n] = (short)(this.count[n] - 1);
                if (this.count[i] == 0) {
                    boolean fncValue = Data.getResultOfNr(i);
                    if (fncValue) {
                        this.noFulfilledLines = (short)(this.noFulfilledLines - 1);
                        this.noFulfilled1Lines = (short)(this.noFulfilled1Lines - 1);
                    } else {
                        this.noFulfilledLines = (short)(this.noFulfilledLines + 1);
                    }
                }
            }
            ++i;
        }
    }

    public void deleteAnd(AndNode an) {
        this.AndNodeCheck(an);
        if (!this.emptyTreeForbidden || this.root.getNumberOfChildren() > 1) {
            BitSet bs = an.getValueBitset();
            this.subBitSetFromCount(bs);
            this.root.deleteChild(an);
        }
    }

    public void deleteCompare(AndNode an, StaticCompareNode cn) {
        this.AndPlusCompareNodeCheck(an, cn);
        if (!this.emptyAndsForbidden || an.getNumberOfChildren() > 1) {
            BitSet bs = an.getValueBitset();
            this.subBitSetFromCount(bs);
            an.deleteChild(cn);
            bs = an.getValueBitset();
            this.addBitSetToCount(bs);
        }
    }

    public void deleteCompare(int index1, int index2) {
        this.AndPlusCompareNodeCheck(index1, index2);
        AndNode an = (AndNode)this.root.getChildAt(index1);
        StaticCompareNode cn = (StaticCompareNode)an.getChildAt(index2);
        this.deleteCompare(an, cn);
    }

    private void addBitSetToCount(BitSet bs) {
        int noOfRows = Data.getNumRows();
        int i = 0;
        while (i < noOfRows) {
            if (bs.get(i)) {
                if (this.count[i] == 0) {
                    boolean fncValue = Data.getResultOfNr(i);
                    if (fncValue) {
                        this.noFulfilledLines = (short)(this.noFulfilledLines + 1);
                        this.noFulfilled1Lines = (short)(this.noFulfilled1Lines + 1);
                    } else {
                        this.noFulfilledLines = (short)(this.noFulfilledLines - 1);
                    }
                }
                int n = i;
                this.count[n] = (short)(this.count[n] + 1);
            }
            ++i;
        }
    }

    private AndNode convertONtoAN(OperatorNode on) {
        if (!(on instanceof AndNode)) {
            throw new RuntimeException("on is no AndNode.");
        }
        return (AndNode)on;
    }

    public void insertAnd(AndNode an) {
        this.rootCheck();
        if (an == null) {
            throw new RuntimeException("You are trying to insert an AndNode that is null.");
        }
        if (!this.emptyAndsForbidden || an.getNumberOfChildren() != 0) {
            this.root.addChild(an);
            BitSet bs = an.getValueBitset();
            this.addBitSetToCount(bs);
        }
    }

    public void insertListOfAndNodes(OperatorNodeVector onodes) {
        int i = 0;
        while (i < onodes.size()) {
            OperatorNode on = onodes.get(i);
            AndNode an = this.convertONtoAN(on);
            this.insertAnd(an);
            ++i;
        }
    }

    public void insertCompare(AndNode an, StaticCompareNode cn) {
        this.AndNodeCheck(an);
        BitSet bs = an.getValueBitset();
        this.subBitSetFromCount(bs);
        this.insertCompareNoAndInTreeCheck(an, cn);
        bs = an.getValueBitset();
        this.addBitSetToCount(bs);
    }

    public void insertCompare(int index, StaticCompareNode cn) {
        this.AndNodeCheck(index);
        AndNode an = (AndNode)this.root.getChildAt(index);
        this.insertCompare(an, cn);
    }

    public void insertCompareNoAndInTreeCheck(AndNode an, StaticCompareNode cn) {
        this.CompareNodeValidCheck(cn);
        if (an != null) {
            an.addChild(cn);
        }
    }

    private void insertAndWithCompare() {
        AndNode an = this.getEmptyAndNode();
        StaticCompareNode cn = this.getExistingCompareNodeRandomly();
        this.insertCompareNoAndInTreeCheck(an, cn);
        this.insertAnd(an);
    }

    public String toDotGraph() {
        return this.root.toDotGraph();
    }

    public BitSet getLiteralBitSet() {
        return this.root.getLiteralBitSet();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DNFTree)) {
            return false;
        }
        DNFTree dnft = (DNFTree)o;
        MultipleOperatorNode root2 = dnft.getRoot();
        return this.root.equals(root2);
    }

    public String toString() {
        return this.root.toString();
    }

    public Object clone() {
        OrNode or = (OrNode)this.root.clone();
        DNFTree tree = new DNFTree(this.count, this.noFulfilledLines, this.noFulfilled1Lines, or, this.xyRange, this.maxPercent, this.emptyAndsForbidden, this.emptyTreeForbidden, this.inputFilePath, this.schedule, this.population, false);
        return tree;
    }

    public void update() {
        this.root.updateBitset();
        this.count = new short[Data.getNumRows()];
        this.noFulfilledLines = 0;
        this.noFulfilled1Lines = 0;
        int i = 0;
        while (i < this.count.length) {
            this.count[i] = 0;
            if (this.count[i] == 1 == Data.getResultOfNr(i)) {
                this.noFulfilledLines = (short)(this.noFulfilledLines + 1);
                if (this.count[i] == 1) {
                    this.noFulfilled1Lines = (short)(this.noFulfilled1Lines + 1);
                }
            }
            ++i;
        }
        OperatorNodeVector onv = this.getAllUsedAndNodes();
        Iterator it = onv.iterator();
        while (it.hasNext()) {
            this.addBitSetToCount(((OperatorNode)it.next()).getValueBitset());
        }
    }

    public void setEmptyAndsForbidden(boolean emptyAndsForbidden) {
        this.emptyAndsForbidden = emptyAndsForbidden;
    }

    public void setEmptyTreeForbidden(boolean emptyTreeForbidden) {
        this.emptyTreeForbidden = emptyTreeForbidden;
    }
}

