% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/experiments.R
\name{list_experiments}
\alias{list_experiments}
\title{Lists experiments to which the user has access to}
\usage{
list_experiments(account.id, webproperty.id, profile.id, start.index = NULL,
  max.results = NULL, token)
}
\arguments{
\item{account.id}{Account ID to retrieve experiments for.}

\item{webproperty.id}{Web property ID to retrieve experiments for.}

\item{profile.id}{View (Profile) ID to retrieve experiments for.}

\item{start.index}{integer. An index of the first experiment to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of experiments to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An experiment collection lists Analytics experiments to which the user has access. Each view (profile) can have a set of experiments. Each resource in the Experiment collection corresponds to a single Analytics experiment.
\item{id}{Experiment ID. Required for patch and update. Disallowed for create.}
\item{account.id}{Account ID to which this experiment belongs.}
\item{webproperty.id}{Web property ID to which this experiment belongs. The web property ID is of the form UA-XXXXX-YY.}
\item{profile.id}{View (Profile) ID to which this experiment belongs.}
\item{name}{Experiment name. This field may not be changed for an experiment whose status is ENDED.}
\item{description}{Notes about this experiment.}
\item{objective.metric}{The metric that the experiment is optimizing.}
\item{optimization.type}{Whether the objectiveMetric should be minimized or maximized.}
\item{status}{Experiment status.}
\item{winner.found}{Boolean specifying whether a winner has been found for this experiment.}
\item{rewrite.variation.urls.as.original}{Boolean specifying whether variations URLS are rewritten to match those of the original.}
\item{winner.confidence.level}{A floating-point number between 0 and 1. Specifies the necessary confidence level to choose a winner.}
\item{start.time}{The starting time of the experiment (the time the status changed from READY_TO_RUN to RUNNING).}
\item{end.time}{The ending time of the experiment (the time the status changed from RUNNING to ENDED).}
\item{minimum.experiment.length.in.days}{An integer number in [3, 90]. Specifies the minimum length of the experiment.}
\item{reason.experiment.ended}{Why the experiment ended.}
\item{editable.in.ga.ui}{If true, the end user will be able to edit the experiment via the Google Analytics user interface.}
}
\description{
Lists experiments to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/experiments}{Management API - Experiments}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}}; \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_upload}}; \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_uploads}};
  \code{\link{list_webproperties}}
}

