% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstdate.R
\name{firstdate}
\alias{firstdate}
\title{First Date}
\usage{
firstdate(profileId, token)
}
\arguments{
\item{profileId}{character. Google Analytics profile ID. Can be obtained using the \code{\link{list_profiles}} or via the web interface Google Analytics.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
Start date of collecting the Google Analytics statistics.
}
\description{
Get the first date with available data.
}
\examples{
\dontrun{
authorize()
first_date <- firstdate(profileId = "profile_id")
ga_data <- get_ga("profile_id", start.date = first_date, end.date = "today",
                  metrics = "ga:sessions", dimensions = "ga:source,ga:medium",
                  sort = "-ga:sessions")
}

}
\seealso{
Other Reporting API: \code{\link{get_ga}},
  \code{\link{get_mcf}}, \code{\link{get_realtime}}
}

