% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgcca_predict.R
\name{rgcca_predict}
\alias{rgcca_predict}
\title{Make predictions using RGCCA}
\usage{
rgcca_predict(
  rgcca_res,
  blocks_test = rgcca_res$call$blocks,
  prediction_model = "lm",
  metric = NULL,
  ...
)
}
\arguments{
\item{rgcca_res}{A fitted RGCCA object (see  \code{\link[RGCCA]{rgcca}}).}

\item{blocks_test}{A list of test blocks from which we aim to predict the
associated response block. If the test response block is present among
blocks_test, metrics are computed by comparing the predictions and the
true values.}

\item{prediction_model}{A string giving the model used for prediction.
Please see caret::modelLookup() for a list of the available models.}

\item{metric}{A string indicating the metric of interest.
It should be one of the following scores:

For classification: "Accuracy", "Kappa", "F1", "Sensitivity", "Specificity",
"Pos_Pred_Value", "Neg_Pred_Value", "Precision", "Recall", "Detection_Rate",
"Balanced_Accuracy".

For regression: "RMSE", "MAE".}

\item{...}{Additional parameters to be passed to prediction_model.}
}
\value{
A list containing the following elements:

\item{score}{The score obtained on the testing block. NA if the test
block is missing.}

\item{model}{A list of the models trained using caret to make the
predictions and compute the scores.}

\item{metric}{A list of data.frames containing the scores obtained
on the training and testing sets.}

\item{confusion}{A list containing NA for regression tasks.
Otherwise, the confusion summary produced by caret for train and test.}

\item{projection}{A list of matrices containing the projections
of the test blocks using the canonical components from the fitted RGCCA
object. The response block is not projected.}

\item{prediction}{A list of data.frames with the predictions
of the test and train response blocks.}
}
\description{
This function aims to make predictions combining a fitted RGCCA object
and a prediction model for classification or regression.
}
\examples{
data("Russett")
blocks <- list(
  agriculture = Russett[, 1:3],
  industry = Russett[, 4:5],
  politic = Russett[, 6:8]
)
X_train <- lapply(blocks, function(x) x[seq(1, 30), ])
X_test <- lapply(blocks, function(x) x[seq(31, 47), ])
fit <- rgcca(X_train,
  tau = 1, ncomp = c(3, 2, 3), response = 3
)
res <- rgcca_predict(fit, X_test)
}
