% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_prcomp.R
\name{m_prcomp}
\alias{m_prcomp}
\title{Multiway Principal Component Analysis}
\usage{
m_prcomp(chrom, center = TRUE, scale = TRUE, npcs = 3, ...)
}
\arguments{
\item{chrom}{Multiple chromatograms readed or batch aligned}

\item{center}{A logical value indicating whether the variables should be
shifted to be zero centered. True is set by default and is strongly
seggested not to change to False.}

\item{scale}{a logical value indicating whether the variables should
be scaled to have unit variance before the analysis takes place. The
default is True to give the same variable importance in chemometrics.}

\item{npcs}{an integer indicating how many principals components are
desired to mantain. The default is 3 principal components.}

\item{...}{Other argments passed to prcomp function.}
}
\value{
MPCA returns a list whit class "MPCA" containing the summary of the
  analysis, the scores matrix, and unfolded loadings, and the metadata if it
  was providen when chromatograms were joined.
}
\description{
`MPCA` Performs a multiway principal components analysis on the given
bidimensional chromatograms and returns the rusults  as object of class
MPCA.
Before to perform the calculation, each given chromatogramas are unfolded
to a single dimension. All chromatograms are merged and principal component 
analysis is performed with the built-in \code{\link[stats]{prcomp}} function.
The print method for these objects prints the summary of the analysis.
This algorithm was first presented by \insertCite{Wold1987}{RGCxGC}.
}
\examples{

data(MTBLS579)
\donttest{
MTBLS579_mpca <- m_prcomp(MTBLS579)
print(MTBLS579_mpca)
scores(MTBLS579_mpca)
plot_loading(MTBLS579_mpca)
}

}
\references{
\insertAllCited{}
}
