% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modMosaic.R
\name{modMosaic}
\alias{modMosaic}
\title{Mosaic a set of MODIS images}
\usage{
modMosaic(src, AppRoot, region = NULL, out.name = "outfile",
  verbose = FALSE, gutils = TRUE, overwrite = FALSE, ...)
}
\arguments{
\item{src}{the path of the folder with the MODIS images in GTiff format.}

\item{AppRoot}{the directory where the mosaicked images are saved.}

\item{region}{a \code{Spatial*}, projected \code{raster*}, or \code{sf} class object 
defining the area of interest.}

\item{out.name}{the name of the folder that stores the outputs. By default,
“outfile” is assigned.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{gutils}{logical argument. If \code{TRUE}, the function uses `GDAL' 
utilities for mosaicking.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing 
images with the same name.}

\item{...}{arguments for nested functions:
 \itemize{
  \item \code{pathrow} a \code{vector} of \code{character} with the 
  path and row numbers of the tiles concerning the region of interest in
  'hXXvYY' format. This argument is mandatory if \code{region} is not provided.
  \item \code{bFilter} a vector with the bands to be mosaicked. If not
  supplied, all bands are mosaicked.
  \item \code{dates} a vector with the capturing dates being considered
  for mosaicking. If not supplied, all dates are mosaicked.
}}
}
\description{
\code{modMosaic} merges the MODIS imagery that covers a 
region of interest on the same dates.
}
\details{
The function mosaics the imagery in the \code{src} folder. The folder can
hold GTiff images from several tiles, dates and bands. When only a subset
dates has to be mosaicked, the dates should be provided through the argument
\code{dates}. The dates must be provided as a \code{Date} class objects. For
further details about the \code{bFilter} argument, go to the 
\code{\link{modDownload}} function. Once mosaicked, the images can be cropped
to fit the \code{region} (optional). The \code{region} can be defined in any
coordinate reference system, since \code{modMosaic} automatically reproject
the extent to match the projection of the image. The outputs will be placed
in the \code{AppRoot} directory, under the folder named as \code{out.name}.
If no name is provided, the folder is named “outfile”.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# main output directory
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
print(wdir)
# download MODIS images
modDownSearch(product = "MOD09GA",
              startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
              endDate = as.Date("03-01-2018", "\%d-\%m-\%Y"),
              username = "username",
              password = "password",
              AppRoot = wdir,
              extract.tif = TRUE,
              collection = 6,
              extent = ex.navarre)
# folder with the MODIS images extracted 
wdir.mod <- file.path(wdir, "Modis", "MOD09GA")
wdir.mod.tif <- file.path(wdir.mod, "tif")
# mosaic the MODIS images
modMosaic(wdir.mod.tif,
          AppRoot = wdir.mod,
          out.name = "Navarre",
          gutils = TRUE,
          overwrite = TRUE,
          region = ex.navarre)
}
}
