% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRTList.R
\name{plot,HRTList-method}
\alias{plot,HRTList-method}
\title{Plot an HRTList object}
\usage{
\S4method{plot}{HRTList}(
  x,
  cropped = TRUE,
  TT = FALSE,
  pch = 20,
  xlab = "# of RR interval",
  ylab = "length of RR interval (ms)",
  paramsLegend = TRUE,
  colTO = "#ec2023",
  colTS = "#006AFF",
  colTT = "#6800DE",
  ...
)
}
\arguments{
\item{x}{HRTList}

\item{cropped}{(Boolean) Should the plot be cut to focus on the HRT parameters?
To show all points use FALSE.}

\item{TT}{(Boolean) Should Turbulence timing be marked?}

\item{pch}{(Numeric) Plotting character, for other options see graphics::var}

\item{xlab}{(Character) Label for the x axis}

\item{ylab}{(Character) Label for the y axis}

\item{paramsLegend}{(Boolean) Should the parameter values of the HRT be plotted?}

\item{colTO}{(Character) Colour used to highlight TO}

\item{colTS}{(Character) Colour used to highlight TS}

\item{colTT}{(Character) Colour used to highlight TT}

\item{...}{Other arguments in tag = value form}
}
\value{
No return value
}
\description{
Plots RR-intervals saved in the HRT objects, especially the avHRT object,
and marks the HRT parameters.
}
\note{
Please note that some graphics parameters (par) cannot be modified,
 since they are needed to be set inside the function.
}
\examples{
# You need an HRTList
hrtl <- vectorToHRT(testdataLong, testdataLong_Ann)

# Plot your HRTList and zoom out
plot(hrtl, cropped = FALSE)

# Include TT and customise it
plot(hrtl, TT = TRUE, colTT = "green", pch = 7)

# Use standard graphics parameters
## Note: Some parameters are used inside the function and cannot be set
plot(hrtl, TT = TRUE, main = "Example plot", bty = "n", cex.lab = 1.2)

}
