% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion_to_HRT.R
\name{vectorToHRT}
\alias{vectorToHRT}
\title{Convert a vector to HRTList}
\usage{
vectorToHRT(
  input,
  annotations = NULL,
  PVCAnn = "V",
  normIL = c_normIL,
  normHallstrom = TRUE,
  numPreRRs = c_numPreRRs,
  numPostRRs = c_numPostRRs,
  inputName = as.character(NA),
  minHRT = 5,
  cleaning = TRUE
)
}
\arguments{
\item{input}{(Numeric vector) RR intervals in ms}

\item{annotations}{(Character vector) Annotations matching input}

\item{PVCAnn}{(Character) Character that marks a VPC in the annotations}

\item{normIL}{(Numeric) The interval length to which TS should be normalised}

\item{normHallstrom}{(Boolean) Should the normalisation of Hallstrom be used?}

\item{numPreRRs}{(Numeric) Number of RRs before the coupling interval that are used for filtering}

\item{numPostRRs}{(Numeric) Number of RRs after the compensatory interval that are used for filtering}

\item{inputName}{(String) Name of the data}

\item{minHRT}{(Numeric) Minimal number of HRTs that are needed to create an HRTList object}

\item{cleaning}{(Boolean) Should the input be roughly cleaned from artefacts before calculating IL and RMSSD?}
}
\value{
(HRTList) An HRTList object
}
\description{
Scans for heart rate turbulence in a vector of RR-intervals and returns an
HRTList object including all found HRT objects.
The HRT criteria used were published by Schmidt et al.
(more information can be found in the vignette.)
}
\examples{
# Find HRTs with a broader range of sinus beats before and after the VPCs
vectorToHRT(testdataLong, inputName = "Dummy Measurement", numPreRRs = 10, numPostRRs = 20)

# Use annotations to give the VPC indices
vectorToHRT(testdataLong, annotations = testdataLong_Ann, PVCAnn = "V")

# Adjust the normalisation parameters
vectorToHRT(testdataLong, normHallstrom = FALSE, normIL = 900)

}
