% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotHR.R
\name{PlotHR}
\alias{PlotHR}
\title{Simple plot of interpolated heart rate}
\usage{
PlotHR(HRVData, Tags = NULL, Indexes = NULL,
  main = "Interpolated instantaneous heart rate", xlab = "time (sec.)",
  ylab = "HR (beats/min.)", type = "l", ylim = NULL, Tag = NULL,
  verbose = NULL, ...)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information 
related to it.}

\item{Tags}{List of tags to specify which episodes, as apnoea or oxygen 
desaturation, are included in the plot. \emph{Tags}="all" plots all episodes present
in the data.}

\item{Indexes}{List of indexes of episodes (see \code{\link{ListEpisodes}})
to specify which episodes are included in the plot. 
\emph{Indexes}="all" plots all episodes present in the data.}

\item{main}{A main title for the plot.}

\item{xlab}{A label for the x axis.}

\item{ylab}{a label for the y axis}

\item{type}{1-character string giving the type of plot desired. See 
\code{\link[graphics]{plot.default}}.}

\item{ylim}{The y limits of the plot.}

\item{Tag}{Deprecated argument maintained for
compatibility, use \emph{Tags} instead.}

\item{verbose}{Deprecated argument maintained for compatibility, 
use SetVerbose() instead}

\item{...}{Other graphical parameters. See 
\code{\link[graphics]{plot.default}}.}
}
\description{
Plots in a simple way the interpolated instantaneous heart
 rate signal.
}
\details{
PlotHR
}
\author{
M. Lado, A. Mendez, D. Olivieri, L. Rodriguez, X. Vila, C.A. Garcia
}
\references{
L. Rodriguez-Linares, L., A.J. Mendez, M.J. Lado, D.N. Olivieri,
X.A. Vila, and I. Gomez-Conde, "An open source tool for heart rate
variability spectral analysis", Computer Methods and Programs in
Biomedicine 103(1):39-50, july 2011.
}
\keyword{aplot}

